/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.animation;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import noppes.npcs.CustomNpcs;
import noppes.npcs.LogWriter;
import noppes.npcs.api.constants.AnimationKind;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.client.Client;
import noppes.npcs.client.gui.SubGuiColorSelector;
import noppes.npcs.client.gui.SubGuiEditText;
import noppes.npcs.client.gui.SubGuiSelectItemStack;
import noppes.npcs.client.gui.animation.GuiNpcAnimation;
import noppes.npcs.client.gui.animation.SubGuiEditAddPart;
import noppes.npcs.client.gui.select.GuiSoundSelection;
import noppes.npcs.client.gui.util.GuiButtonBiDirectional;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiNPCInterface;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcCheckBox;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.GuiNpcMiniWindow;
import noppes.npcs.client.gui.util.GuiNpcSlider;
import noppes.npcs.client.gui.util.GuiNpcTextField;
import noppes.npcs.client.gui.util.IComponentGui;
import noppes.npcs.client.gui.util.ICustomScrollListener;
import noppes.npcs.client.gui.util.IGuiCustomScroll;
import noppes.npcs.client.gui.util.IGuiNpcButton;
import noppes.npcs.client.gui.util.IGuiNpcMiniWindow;
import noppes.npcs.client.gui.util.IGuiNpcSlider;
import noppes.npcs.client.gui.util.IGuiNpcTextField;
import noppes.npcs.client.gui.util.ISliderListener;
import noppes.npcs.client.gui.util.ISubGuiListener;
import noppes.npcs.client.gui.util.ITextfieldListener;
import noppes.npcs.client.gui.util.SubGuiInterface;
import noppes.npcs.client.model.ModelNpcAlt;
import noppes.npcs.client.model.animation.AddedPartConfig;
import noppes.npcs.client.model.animation.AnimationConfig;
import noppes.npcs.client.model.animation.AnimationDamageHitbox;
import noppes.npcs.client.model.animation.AnimationFrameConfig;
import noppes.npcs.client.model.animation.PartConfig;
import noppes.npcs.constants.EnumAnimationStages;
import noppes.npcs.constants.EnumPacketServer;
import noppes.npcs.controllers.AnimationController;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.util.Util;
import noppes.npcs.util.ValueUtil;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class SubGuiEditAnimation
extends SubGuiInterface
implements ISubGuiListener,
ISliderListener,
ICustomScrollListener,
ITextfieldListener,
GuiYesNoCallback {
    public static int meshType = 1;
    public static boolean showHitBox = true;
    public AnimationConfig anim;
    public AnimationFrameConfig frame;
    public PartConfig part;
    public AddedPartConfig addedPartConfig;
    public AnimationDamageHitbox hitbox;
    private GuiCustomScroll scrollParts;
    private GuiCustomScroll scrollHitboxes;
    private int blockType;
    private int blockSize;
    private int toolType;
    private int waitKey;
    private int waitKeyID;
    private boolean onlyCurrentPart;
    private boolean hovered;
    private boolean hasExtend;
    private boolean hoverRight;
    private boolean hoverLeft;
    private boolean isHitbox = false;
    private boolean isMotion = false;
    private boolean isChanged = true;
    private final EntityNPCInterface npcAnim;
    private final EntityNPCInterface npcPart;
    private final double[] basePos;
    private final String[] blockNames;
    private final String[] blockSizes;
    private int workU;
    private int workV;
    private int workS;
    private int winU;
    private int winV;
    private int winW;
    private int winH;
    private int mousePressId = -1;
    private int mousePressX = 0;
    private int mousePressY = 0;
    private final float[] dispRot = new float[]{45.0f, 345.0f, 345.0f};
    private final float[] dispPos = new float[]{0.0f, 0.0f, 0.0f};
    private float dispScale = 1.0f;
    private float winScale;
    private float offsetY;
    private final Map<String, PartConfig> dataParts = new LinkedHashMap<String, PartConfig>();
    private final Map<String, AnimationDamageHitbox> dataHitboxes = new LinkedHashMap<String, AnimationDamageHitbox>();
    private final List<Entity> environmentEntitys = new ArrayList<Entity>();
    private final Map<BlockPos, IBlockState> environmentStates = new HashMap<BlockPos, IBlockState>();
    private final Map<BlockPos, TileEntity> environmentTiles = new HashMap<BlockPos, TileEntity>();
    private GuiNpcMiniWindow partNames;
    private GuiNpcMiniWindow tools;
    private GuiNpcMiniWindow hitboxes;
    private double w = -1.0;
    private double h = -1.0;
    private float baseRotation = 0.0f;

    public SubGuiEditAnimation(EntityNPCInterface npc, AnimationConfig animation, int animId, GuiNpcAnimation parentGUI) {
        super(npc);
        this.id = animId;
        this.ySize = 240;
        this.xSize = 427;
        this.parent = parentGUI;
        this.anim = animation;
        this.frame = this.anim.frames.get(0);
        this.setPart(this.frame.parts.get(3));
        this.setHitbox(this.frame.damageHitboxes.get(0));
        this.waitKey = 0;
        this.toolType = 0;
        this.blockType = 0;
        this.blockSize = 2;
        this.winScale = 1.0f;
        this.setEnvironment();
        this.onlyCurrentPart = false;
        this.baseRotation = npc.field_70177_z;
        this.basePos = new double[]{npc.field_70165_t, npc.field_70163_u, npc.field_70161_v};
        this.npcAnim = Util.instance.copyToGUI(npc, (World)this.field_146297_k.field_71441_e, true);
        this.npcAnim.display.setName(npc.func_70005_c_() + "_animation");
        this.npcPart = Util.instance.copyToGUI(npc, (World)this.field_146297_k.field_71441_e, true);
        this.npcPart.display.setName(npc.func_70005_c_() + "_anim_part");
        GuiNpcButton b = new GuiNpcButton(47, 0, 0, "");
        this.buttonEvent(b);
        this.buttonEvent(b);
        this.blockNames = new String[6];
        this.blockNames[0] = "gui.environment";
        this.blockNames[1] = "gui.none";
        for (int i = 0; i < 4; ++i) {
            Block block;
            switch (i) {
                case 1: {
                    block = Blocks.field_150446_ar;
                    break;
                }
                case 2: {
                    block = Blocks.field_150333_U;
                    break;
                }
                case 3: {
                    block = Blocks.field_150404_cg;
                    break;
                }
                default: {
                    block = Blocks.field_150348_b;
                }
            }
            this.blockNames[i + 2] = new ItemStack(block).func_82833_r();
        }
        this.blockSizes = new String[]{"x1", "x3", "x5", "x7", "x9"};
        ModelNpcAlt.editAnimDataSelect.red = (float)(CustomNpcs.colorAnimHoverPart >> 16 & 0xFF) / 255.0f;
        ModelNpcAlt.editAnimDataSelect.green = (float)(CustomNpcs.colorAnimHoverPart >> 8 & 0xFF) / 255.0f;
        ModelNpcAlt.editAnimDataSelect.blue = (float)(CustomNpcs.colorAnimHoverPart & 0xFF) / 255.0f;
    }

    private void setPart(PartConfig partConfig) {
        GuiNpcTextField.unfocus();
        if (partConfig != null) {
            this.part = this.frame.parts.get(partConfig.id);
        }
        ModelNpcAlt.editAnimDataSelect.part = this.part == null || this.isHitbox || this.isMotion ? -1 : this.part.id;
        this.addedPartConfig = this.part != null && this.part.id > 7 ? this.anim.getAddedPart(this.part.id) : null;
        if (this.tools != null && this.tools.visible) {
            this.showTools();
        }
    }

    private void setHitbox(AnimationDamageHitbox hitboxConfig) {
        GuiNpcTextField.unfocus();
        if (hitboxConfig != null) {
            this.hitbox = this.frame.damageHitboxes.get(hitboxConfig.id);
            if (this.scrollHitboxes != null && this.scrollHitboxes.hasSelected()) {
                this.isHitbox = true;
                ModelNpcAlt.editAnimDataSelect.part = -1;
                this.onlyCurrentPart = true;
                if (this.getButton(21) != null) {
                    this.getButton(21).setTextureXY(144, this.getButton(21).getTextureXY()[1]);
                }
            }
        } else {
            this.isHitbox = false;
            if (this.scrollHitboxes != null) {
                this.scrollHitboxes.setSelected(null);
            }
        }
        if (this.tools != null && this.tools.visible) {
            this.showTools();
        }
    }

    @Override
    public void buttonEvent(IGuiNpcButton button) {
        switch (button.getID()) {
            case 0: {
                this.blockType = button.getValue();
                if (this.getButton(16) == null) break;
                this.getButton(16).setEnabled(this.blockType != 1);
                break;
            }
            case 1: {
                this.blockSize = button.getValue();
                break;
            }
            case 2: {
                GuiNpcAnimation.backColor = GuiNpcAnimation.backColor == -16777216 ? -1 : -16777216;
                this.getLabel(50).setColor(GuiNpcAnimation.backColor);
                button.setLayerColor(GuiNpcAnimation.backColor == -16777216 ? -16711681 : -16744320);
                break;
            }
            case 3: {
                if (this.anim == null || this.part == null || !this.anim.frames.containsKey(button.getValue()) || this.anim.frames.get((Object)Integer.valueOf((int)button.getValue())).id == -1) {
                    return;
                }
                this.frame = this.anim.frames.get(button.getValue());
                this.setPart(this.frame.parts.get(this.part.id));
                this.setHitbox(this.frame.damageHitboxes.get(0));
                this.anim.editTick = 0;
                this.anim.editFrame = this.frame.id;
                this.func_73866_w_();
                break;
            }
            case 4: {
                if (this.anim == null) {
                    return;
                }
                if (GuiScreen.func_146272_n()) {
                    SubGuiEditText subgui = new SubGuiEditText(0, "" + this.anim.frames.size());
                    subgui.numbersOnly = new int[]{0, this.anim.frames.size(), this.anim.frames.size()};
                    this.setSubGui(subgui);
                    break;
                }
                this.frame = (AnimationFrameConfig)this.anim.addFrame(-1, this.frame);
                this.setPart(this.frame.parts.get(this.part.id));
                this.func_73866_w_();
                break;
            }
            case 5: {
                if (this.frame == null) {
                    return;
                }
                GuiYesNo guiyesno = new GuiYesNo((GuiYesNoCallback)this, new TextComponentTranslation("animation.clear.frame", new Object[]{"" + (this.frame.id + 1)}).func_150254_d(), new TextComponentTranslation("gui.deleteMessage", new Object[0]).func_150254_d(), 0);
                this.displayGuiScreen((GuiScreen)guiyesno);
                break;
            }
            case 6: {
                if (this.frame == null) {
                    return;
                }
                GuiYesNo guiyesno = new GuiYesNo((GuiYesNoCallback)this, new TextComponentTranslation("animation.clear.frame", new Object[]{"" + (this.frame.id + 1)}).func_150254_d(), new TextComponentTranslation("gui.clearMessage", new Object[0]).func_150254_d(), GuiScreen.func_146272_n() ? 4 : 1);
                this.displayGuiScreen((GuiScreen)guiyesno);
                break;
            }
            case 7: {
                if (this.isHitbox) {
                    if (this.hitbox == null) {
                        return;
                    }
                    this.hitbox = new AnimationDamageHitbox(this.frame.damageHitboxes.size());
                    this.hitbox.clear();
                    this.frame.damageHitboxes.put(this.hitbox.id, this.hitbox);
                    this.func_73866_w_();
                    break;
                }
                if (this.isMotion || this.anim == null || this.part == null || this.part.id == 6 || this.part.id == 7) {
                    return;
                }
                SubGuiEditAddPart sGui = new SubGuiEditAddPart(this, this.npc, this.npcPart, null, null);
                sGui.addPart.parentPart = this.part.id;
                this.setSubGui(sGui);
                break;
            }
            case 8: {
                if (this.isHitbox) {
                    if (this.hitbox == null) {
                        return;
                    }
                    if (this.frame.damageHitboxes.size() == 1) {
                        this.hitbox.clear();
                    } else {
                        int id = this.hitbox.id;
                        this.frame.damageHitboxes.remove(id);
                        this.hitbox = this.frame.damageHitboxes.get(id - 1);
                    }
                    this.func_73866_w_();
                    break;
                }
                if (this.isMotion || this.anim == null || this.addedPartConfig == null || this.part == null) {
                    return;
                }
                GuiYesNo guiyesno = new GuiYesNo((GuiYesNoCallback)this, new TextComponentTranslation("animation.clear.part", new Object[]{"" + (this.part.id + 1), this.scrollParts.getSelected()}).func_150254_d(), new TextComponentTranslation("gui.deleteMessage", new Object[0]).func_150254_d(), 2);
                this.displayGuiScreen((GuiScreen)guiyesno);
                break;
            }
            case 9: {
                if (this.part == null) {
                    return;
                }
                GuiYesNo guiyesno = new GuiYesNo((GuiYesNoCallback)this, new TextComponentTranslation("animation.clear.part", new Object[]{"" + (this.part.id + 1), this.scrollParts.getSelected()}).func_150254_d(), new TextComponentTranslation("gui.clearMessage", new Object[0]).func_150254_d(), GuiScreen.func_146272_n() ? 5 : 3);
                this.displayGuiScreen((GuiScreen)guiyesno);
                break;
            }
            case 10: {
                if (this.anim == null || this.part == null) {
                    return;
                }
                this.part.setDisable(((GuiNpcCheckBox)button).isSelected());
                if (GuiScreen.func_146272_n()) {
                    for (AnimationFrameConfig f : this.anim.frames.values()) {
                        f.parts.get(this.part.id).setDisable(this.part.isDisable());
                    }
                }
                button.setHoverText(new TextComponentTranslation("animation.hover.part.disabled." + !this.part.isDisable(), new Object[0]).func_150257_a((ITextComponent)new TextComponentTranslation("animation.hover.shift.1", new Object[0])).func_150254_d(), new Object[0]);
                this.resetAnimation();
                break;
            }
            case 11: {
                if (this.anim == null || this.frame == null) {
                    return;
                }
                this.frame.setSmooth(((GuiNpcCheckBox)button).isSelected());
                if (GuiScreen.func_146272_n()) {
                    for (AnimationFrameConfig f : this.anim.frames.values()) {
                        f.setSmooth(this.frame.isSmooth());
                    }
                }
                button.setHoverText("animation.hover.smooth." + this.frame.isSmooth(), new Object[0]);
                this.resetAnimation();
                break;
            }
            case 12: {
                this.setSubGui(new SubGuiColorSelector(CustomNpcs.colorAnimHoverPart));
                break;
            }
            case 13: {
                if (meshType == 0) {
                    meshType = -1;
                    button.setLayerColor(-13235172);
                } else {
                    meshType = 0;
                    button.setLayerColor(-2543504);
                }
                if (this.getButton(14) != null) {
                    this.getButton(14).setLayerColor(-15070154);
                }
                if (this.getButton(15) != null) {
                    this.getButton(15).setLayerColor(-15976928);
                }
                if (this.getButton(16) == null) break;
                this.getButton(16).setLayerColor(-13289972);
                break;
            }
            case 14: {
                if (meshType == 1) {
                    meshType = -1;
                    button.setLayerColor(-15070154);
                } else {
                    meshType = 1;
                    button.setLayerColor(-9948967);
                }
                if (this.getButton(13) != null) {
                    this.getButton(13).setLayerColor(-13235172);
                }
                if (this.getButton(15) != null) {
                    this.getButton(15).setLayerColor(-15976928);
                }
                if (this.getButton(16) == null) break;
                this.getButton(16).setLayerColor(-13289972);
                break;
            }
            case 15: {
                if (meshType == 2) {
                    meshType = -1;
                    button.setLayerColor(-15976928);
                } else {
                    meshType = 2;
                    button.setLayerColor(-13575808);
                }
                if (this.getButton(13) != null) {
                    this.getButton(13).setLayerColor(-13235172);
                }
                if (this.getButton(14) != null) {
                    this.getButton(14).setLayerColor(-15070154);
                }
                if (this.getButton(16) == null) break;
                this.getButton(16).setLayerColor(-13289972);
                break;
            }
            case 16: {
                if (meshType == 3) {
                    meshType = -1;
                    button.setLayerColor(-13289972);
                } else {
                    meshType = 3;
                    button.setLayerColor(-2631376);
                }
                if (this.getButton(13) != null) {
                    this.getButton(13).setLayerColor(-13235172);
                }
                if (this.getButton(14) != null) {
                    this.getButton(14).setLayerColor(-15070154);
                }
                if (this.getButton(15) == null) break;
                this.getButton(15).setLayerColor(-15976928);
                break;
            }
            case 17: {
                showHitBox = !showHitBox;
                button.setLayerColor(showHitBox ? 0 : -8355712);
                break;
            }
            case 18: {
                this.dispScale = 1.0f;
                break;
            }
            case 19: {
                for (int i = 0; i < 3; ++i) {
                    this.dispPos[i] = 0.0f;
                }
                break;
            }
            case 20: {
                this.dispRot[0] = 45.0f;
                this.dispRot[1] = 345.0f;
                this.dispRot[2] = 345.0f;
                break;
            }
            case 21: {
                if (this.isHitbox || this.isMotion) {
                    return;
                }
                this.onlyCurrentPart = !this.onlyCurrentPart;
                button.setTextureXY(this.onlyCurrentPart ? 144 : 188, button.getTextureXY()[1]);
                this.resetAnimation();
                break;
            }
            case 22: {
                if (this.anim == null || this.part == null) {
                    return;
                }
                this.part.setShow(((GuiNpcCheckBox)button).isSelected());
                if (GuiScreen.func_146272_n()) {
                    for (AnimationFrameConfig f : this.anim.frames.values()) {
                        f.parts.get(this.part.id).setShow(this.part.isShow());
                    }
                }
                button.setHoverText(new TextComponentTranslation("animation.hover.part.show." + this.part.isShow(), new Object[0]).func_150257_a((ITextComponent)new TextComponentTranslation("animation.hover.shift.1", new Object[0])).func_150254_d(), new Object[0]);
                this.resetAnimation();
                break;
            }
            case 23: {
                if (this.toolType == 1) {
                    return;
                }
                GuiNpcTextField.unfocus();
                this.toolType = 1;
                this.func_73866_w_();
                break;
            }
            case 24: {
                if (this.toolType == 0) {
                    return;
                }
                GuiNpcTextField.unfocus();
                this.toolType = 0;
                this.func_73866_w_();
                break;
            }
            case 25: {
                if (this.toolType == 2) {
                    return;
                }
                GuiNpcTextField.unfocus();
                this.toolType = 2;
                this.func_73866_w_();
                break;
            }
            case 26: {
                ModelNpcAlt.editAnimDataSelect.showArmor = !ModelNpcAlt.editAnimDataSelect.showArmor;
                button.setLayerColor(ModelNpcAlt.editAnimDataSelect.showArmor ? -36352 : -9489920);
                break;
            }
            case 27: {
                if (this.frame == null) {
                    return;
                }
                this.setSubGui(new GuiSoundSelection(this.frame.getStartSound()));
                break;
            }
            case 28: {
                if (this.frame == null) {
                    return;
                }
                this.frame.setStartSound("");
                break;
            }
            case 29: {
                if (this.partNames == null) {
                    this.showPartNames();
                }
                if (this.miniWindows.containsKey(this.partNames.id)) {
                    return;
                }
                this.partNames.isMoving = false;
                this.partNames.visible = true;
                this.miniWindows.put(this.partNames.id, this.partNames);
                button.setEnabled(false);
                break;
            }
            case 30: {
                if (this.isHitbox) {
                    if (this.hitbox == null) break;
                    if (this.toolType == 1) {
                        this.hitbox.offset[0] = 0.0f;
                    } else {
                        this.hitbox.scale[0] = 1.0f;
                    }
                    this.func_73866_w_();
                    break;
                }
                if (this.isMotion) {
                    this.frame.motions[0] = 0.0f;
                    this.func_73866_w_();
                    break;
                }
                if (this.part == null) break;
                switch (this.toolType) {
                    case 0: {
                        this.part.rotation[0] = 0.0f;
                        break;
                    }
                    case 1: {
                        this.part.offset[0] = 0.0f;
                        break;
                    }
                    case 2: {
                        this.part.scale[0] = 1.0f;
                    }
                }
                this.func_73866_w_();
                break;
            }
            case 31: {
                if (this.isHitbox) {
                    if (this.hitbox == null) break;
                    if (this.toolType == 1) {
                        this.hitbox.offset[1] = 0.0f;
                    } else {
                        this.hitbox.scale[1] = 1.0f;
                    }
                    this.func_73866_w_();
                    break;
                }
                if (this.isMotion) {
                    this.frame.motions[1] = 0.0f;
                    this.func_73866_w_();
                    break;
                }
                if (this.part == null) break;
                switch (this.toolType) {
                    case 0: {
                        this.part.rotation[1] = 0.0f;
                        break;
                    }
                    case 1: {
                        this.part.offset[1] = 0.0f;
                        break;
                    }
                    case 2: {
                        this.part.scale[1] = 1.0f;
                    }
                }
                this.func_73866_w_();
                break;
            }
            case 32: {
                if (this.isHitbox) {
                    if (this.hitbox == null) break;
                    if (this.toolType == 1) {
                        this.hitbox.offset[2] = 0.0f;
                    } else {
                        this.hitbox.scale[2] = 1.0f;
                    }
                    this.func_73866_w_();
                    break;
                }
                if (this.isMotion) {
                    this.frame.motions[2] = 0.0f;
                    this.func_73866_w_();
                    break;
                }
                if (this.part == null) break;
                switch (this.toolType) {
                    case 0: {
                        this.part.rotation[2] = 0.0f;
                        break;
                    }
                    case 1: {
                        this.part.offset[2] = 0.0f;
                        break;
                    }
                    case 2: {
                        this.part.scale[2] = 1.0f;
                    }
                }
                this.func_73866_w_();
                break;
            }
            case 33: {
                this.part.rotation[3] = 0.0f;
                this.func_73866_w_();
                break;
            }
            case 34: {
                this.part.rotation[4] = 0.0f;
                this.func_73866_w_();
                break;
            }
            case 35: {
                if (this.tools == null) {
                    this.showTools();
                }
                if (this.tools == null) {
                    return;
                }
                this.tools.isMoving = false;
                this.tools.visible = true;
                this.miniWindows.put(this.tools.id, this.tools);
                button.setEnabled(false);
                break;
            }
            case 36: {
                if (this.frame == null) {
                    return;
                }
                this.frame.isNowDamage = ((GuiNpcCheckBox)button).isSelected();
                break;
            }
            case 37: {
                if (this.frame == null) {
                    return;
                }
                this.frame.setHoldRightStackType(button.getValue());
                int type = this.frame.getHoldRightStackType();
                if (type == 2) {
                    type = 3;
                } else if (type == 3) {
                    type = 4;
                }
                button.setHoverText("animation.hover.stack.type." + type, new Object[0]);
                this.resetAnimation();
                break;
            }
            case 38: {
                if (this.frame == null) {
                    return;
                }
                this.frame.setHoldLeftStackType(button.getValue());
                int type = this.frame.getHoldLeftStackType();
                if (type == 3) {
                    type = 4;
                }
                button.setHoverText("animation.hover.stack.type." + type, new Object[0]);
                this.resetAnimation();
                break;
            }
            case 39: {
                if (this.frame == null) {
                    return;
                }
                this.frame.showMainHand = !this.frame.showMainHand;
                this.func_73866_w_();
                break;
            }
            case 40: {
                if (this.frame == null) {
                    return;
                }
                this.frame.showOffHand = !this.frame.showOffHand;
                this.func_73866_w_();
                break;
            }
            case 41: {
                if (this.frame == null) {
                    return;
                }
                this.frame.showHelmet = !this.frame.showHelmet;
                this.func_73866_w_();
                break;
            }
            case 42: {
                if (this.frame == null) {
                    return;
                }
                this.frame.showBody = !this.frame.showBody;
                this.func_73866_w_();
                break;
            }
            case 43: {
                if (this.frame == null) {
                    return;
                }
                this.frame.showLegs = !this.frame.showLegs;
                this.func_73866_w_();
                break;
            }
            case 44: {
                if (this.frame == null) {
                    return;
                }
                this.frame.showFeets = !this.frame.showFeets;
                this.func_73866_w_();
                break;
            }
            case 45: {
                this.showHitBoxes();
                this.hitboxes.isMoving = false;
                this.hitboxes.visible = true;
                this.miniWindows.put(this.hitboxes.id, this.hitboxes);
                button.setEnabled(false);
                break;
            }
            case 46: {
                if (ModelNpcAlt.editAnimDataSelect.alpha >= 1.0f) {
                    ModelNpcAlt.editAnimDataSelect.alpha = 0.25f;
                    button.setLayerColor(-8882344);
                    break;
                }
                ModelNpcAlt.editAnimDataSelect.alpha = 1.0f;
                button.setLayerColor(-321);
                break;
            }
            case 47: {
                if (this.baseRotation == 0.0f) {
                    return;
                }
                if (this.npcAnim.field_70177_z != this.baseRotation) {
                    this.npcAnim.field_70177_z = this.baseRotation;
                    this.npcAnim.field_70126_B = this.baseRotation;
                    this.npcAnim.field_70759_as = this.npc.field_70759_as;
                    this.npcAnim.field_70758_at = this.npc.field_70758_at;
                    this.npcPart.field_70177_z = this.baseRotation;
                    this.npcPart.field_70126_B = this.baseRotation;
                    this.npcPart.field_70759_as = this.npc.field_70759_as;
                    this.npcPart.field_70758_at = this.npc.field_70758_at;
                    button.setLayerColor(-6881344);
                    break;
                }
                this.npcAnim.field_70177_z = 0.0f;
                this.npcAnim.field_70126_B = 0.0f;
                this.npcAnim.field_70759_as = 0.0f;
                this.npcAnim.field_70758_at = 0.0f;
                this.npcPart.field_70177_z = 0.0f;
                this.npcPart.field_70126_B = 0.0f;
                this.npcPart.field_70759_as = 0.0f;
                this.npcPart.field_70758_at = 0.0f;
                button.setLayerColor(-12424109);
                break;
            }
            case 48: {
                this.isMotion = true;
                button.setEnabled(false);
                if (this.toolType != 1) {
                    this.toolType = 1;
                }
                this.scrollHitboxes.setSelected(null);
                this.setHitbox(null);
                this.scrollParts.setSelected(null);
                this.setPart(null);
                this.setHitbox(null);
                this.onlyCurrentPart = true;
                if (this.getButton(21) != null) {
                    this.getButton(21).setTextureXY(144, this.getButton(21).getTextureXY()[1]);
                }
                this.resetAnimation();
                this.func_73866_w_();
                break;
            }
            case 49: {
                this.dispRot[0] = 0.0f;
                this.dispRot[1] = 0.0f;
                this.dispRot[2] = 0.0f;
                break;
            }
            case 50: {
                this.dispRot[0] = 90.0f;
                this.dispRot[1] = 0.0f;
                this.dispRot[2] = 0.0f;
                break;
            }
            case 51: {
                this.dispRot[0] = 0.0f;
                this.dispRot[1] = 270.0f;
                this.dispRot[2] = 0.0f;
                break;
            }
            case 52: {
                this.displayRotate(180, 0);
                break;
            }
            case 53: {
                this.anim.editTick = button.getValue();
                this.resetAnimation();
                break;
            }
            case 66: {
                this.close();
            }
        }
    }

    public void func_73878_a(boolean result, int id) {
        this.displayGuiScreen(this.parent);
        if (!result) {
            return;
        }
        switch (id) {
            case 0: {
                if (this.anim == null || this.frame == null || this.anim.frames.size() <= 1) {
                    return;
                }
                int f = this.frame.id - 1;
                if (f < 0) {
                    f = 0;
                }
                this.anim.removeFrame(this.frame);
                this.frame = this.anim.frames.get(f);
                this.setPart(this.frame.parts.get(this.part.id));
                this.setHitbox(this.frame.damageHitboxes.get(0));
                this.func_73866_w_();
                break;
            }
            case 1: {
                if (this.frame == null) {
                    return;
                }
                for (PartConfig p : this.frame.parts.values()) {
                    p.clear();
                }
                this.func_73866_w_();
                break;
            }
            case 2: {
                if (this.anim == null || this.addedPartConfig == null || this.part == null) {
                    return;
                }
                int f = this.addedPartConfig.id - 1;
                if (f < 0) {
                    f = 0;
                }
                this.anim.removeAddedPart(this.addedPartConfig);
                this.frame = this.anim.frames.get(this.frame.id);
                this.setPart(this.frame.parts.get(f));
                this.func_73866_w_();
                break;
            }
            case 3: {
                if (this.part == null) {
                    return;
                }
                this.part.clear();
                this.func_73866_w_();
                break;
            }
            case 4: {
                if (this.anim == null) {
                    return;
                }
                for (AnimationFrameConfig f : this.anim.frames.values()) {
                    for (PartConfig p : f.parts.values()) {
                        p.clear();
                    }
                }
                this.func_73866_w_();
                break;
            }
            case 5: {
                if (this.anim == null || this.part == null) {
                    return;
                }
                for (AnimationFrameConfig f : this.anim.frames.values()) {
                    f.parts.get(this.part.id).clear();
                }
                this.func_73866_w_();
            }
        }
    }

    private void displayOffset(int x, int y) {
        for (int i = 0; i < 2; ++i) {
            int n = i;
            this.dispPos[n] = this.dispPos[n] + (float)(i == 0 ? x : y);
            if (this.dispPos[i] > (float)this.workS * this.dispScale) {
                this.dispPos[i] = (float)this.workS * this.dispScale;
                continue;
            }
            if (!(this.dispPos[i] < (float)(-this.workS) * this.dispScale)) continue;
            this.dispPos[i] = (float)(-this.workS) * this.dispScale;
        }
    }

    private void displayRotate(int x, int y) {
        this.dispRot[0] = this.dispRot[0] + (float)x;
        this.dispRot[1] = this.dispRot[1] + (float)(Math.cos((double)this.dispRot[0] * Math.PI / 180.0) * (double)y);
        this.dispRot[2] = this.dispRot[2] + (float)(Math.sin((double)this.dispRot[0] * Math.PI / 180.0) * (double)y);
        for (int i = 0; i < 3; ++i) {
            if (this.dispRot[i] > 360.0f) {
                int n = i;
                this.dispRot[n] = this.dispRot[n] - 360.0f;
                continue;
            }
            if (!(this.dispRot[i] < 0.0f)) continue;
            int n = i;
            this.dispRot[n] = this.dispRot[n] + 360.0f;
        }
    }

    private void drawCRect(double left, double top, double right, double bottom, int color) {
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179131_c((float)f, (float)f1, (float)f2, (float)f3);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        bufferbuilder.func_181662_b(left, bottom, 0.0).func_181675_d();
        bufferbuilder.func_181662_b(right, bottom, 0.0).func_181675_d();
        bufferbuilder.func_181662_b(right, top, 0.0).func_181675_d();
        bufferbuilder.func_181662_b(left, top, 0.0).func_181675_d();
        bufferbuilder.func_181662_b(left, bottom, -1.0).func_181675_d();
        bufferbuilder.func_181662_b(left, bottom, 0.0).func_181675_d();
        bufferbuilder.func_181662_b(left, top, 0.0).func_181675_d();
        bufferbuilder.func_181662_b(left, top, -1.0).func_181675_d();
        bufferbuilder.func_181662_b(right, bottom, -1.0).func_181675_d();
        bufferbuilder.func_181662_b(left, bottom, -1.0).func_181675_d();
        bufferbuilder.func_181662_b(left, top, -1.0).func_181675_d();
        bufferbuilder.func_181662_b(right, top, -1.0).func_181675_d();
        bufferbuilder.func_181662_b(right, bottom, 0.0).func_181675_d();
        bufferbuilder.func_181662_b(right, bottom, -1.0).func_181675_d();
        bufferbuilder.func_181662_b(right, top, -1.0).func_181675_d();
        bufferbuilder.func_181662_b(right, top, 0.0).func_181675_d();
        bufferbuilder.func_181662_b(left, top, 0.0).func_181675_d();
        bufferbuilder.func_181662_b(right, top, 0.0).func_181675_d();
        bufferbuilder.func_181662_b(right, top, -1.0).func_181675_d();
        bufferbuilder.func_181662_b(left, top, -1.0).func_181675_d();
        bufferbuilder.func_181662_b(left, bottom, -1.0).func_181675_d();
        bufferbuilder.func_181662_b(right, bottom, -1.0).func_181675_d();
        bufferbuilder.func_181662_b(right, bottom, 0.0).func_181675_d();
        bufferbuilder.func_181662_b(left, bottom, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    private void drawLine(double x, double y, double z, double dist, int type, float red, float green, float blue) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_187441_d((float)2.0f);
        GlStateManager.func_179090_x();
        GlStateManager.func_179132_a((boolean)false);
        buffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        if (type == 0 || type < 0) {
            buffer.func_181662_b(x - dist, y, z).func_181666_a(red, green, blue, 1.0f).func_181675_d();
            buffer.func_181662_b(x + dist, y, z).func_181666_a(red, green, blue, 1.0f).func_181675_d();
        }
        if (type == 1 || type < 0) {
            buffer.func_181662_b(x, y - dist, z).func_181666_a(red, green, blue, 1.0f).func_181675_d();
            buffer.func_181662_b(x, y + dist, z).func_181666_a(red, green, blue, 1.0f).func_181675_d();
        }
        if (type == 2 || type < 0) {
            buffer.func_181662_b(x, y, z - dist).func_181666_a(red, green, blue, 1.0f).func_181675_d();
            buffer.func_181662_b(x, y, z + dist).func_181666_a(red, green, blue, 1.0f).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    private void drawLine(double x0, double z0, double x1, double y1, double z1, float size, float red, float green, float blue) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_187441_d((float)size);
        GlStateManager.func_179090_x();
        GlStateManager.func_179132_a((boolean)false);
        buffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        buffer.func_181662_b(x0, 0.0, z0).func_181666_a(red, green, blue, 1.0f).func_181675_d();
        buffer.func_181662_b(x1, y1, z1).func_181666_a(red, green, blue, 1.0f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    private void drawCircle(double radius, float size, float red, float green, float blue) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_187441_d((float)size);
        GlStateManager.func_179090_x();
        GlStateManager.func_179132_a((boolean)false);
        buffer.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        for (int i = 0; i <= 64; ++i) {
            double angle = (double)i / 64.0 * Math.PI * 2.0;
            buffer.func_181662_b(0.0 + Math.cos(angle) * radius, 0.0, 0.0 + Math.sin(angle) * radius).func_181666_a(red, green, blue, 1.0f).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    private void drawArrow(double radius, float size, float red, float green, float blue) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_187441_d((float)size);
        GlStateManager.func_179090_x();
        GlStateManager.func_179132_a((boolean)false);
        buffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        buffer.func_181662_b(0.0, 0.0, 0.0).func_181666_a(red, green, blue, 1.0f).func_181675_d();
        buffer.func_181662_b(0.0, 0.0, radius).func_181666_a(red, green, blue, 1.0f).func_181675_d();
        buffer.func_181662_b(0.0, 0.0, radius).func_181666_a(red, green, blue, 1.0f).func_181675_d();
        buffer.func_181662_b(radius * 0.05, 0.0, radius * 0.75).func_181666_a(red, green, blue, 1.0f).func_181675_d();
        buffer.func_181662_b(0.0, 0.0, radius).func_181666_a(red, green, blue, 1.0f).func_181675_d();
        buffer.func_181662_b(radius * -0.05, 0.0, radius * 0.75).func_181666_a(red, green, blue, 1.0f).func_181675_d();
        buffer.func_181662_b(0.0, 0.0, radius).func_181666_a(red, green, blue, 1.0f).func_181675_d();
        buffer.func_181662_b(0.0, radius * 0.05, radius * 0.75).func_181666_a(red, green, blue, 1.0f).func_181675_d();
        buffer.func_181662_b(0.0, 0.0, radius).func_181666_a(red, green, blue, 1.0f).func_181675_d();
        buffer.func_181662_b(0.0, radius * -0.05, radius * 0.75).func_181666_a(red, green, blue, 1.0f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        int i;
        List list;
        IItemStack stack;
        int dWheel;
        int y;
        GuiNpcLabel label;
        if (this.subgui != null) {
            this.subgui.func_73863_a(mouseX, mouseY, partialTicks);
            return;
        }
        if (this.w < 0.0 || this.h < 0.0) {
            ScaledResolution sw = new ScaledResolution(this.field_146297_k);
            this.w = sw.func_78326_a();
            this.h = sw.func_78328_b();
        }
        if (this.waitKey != 0) {
            --this.waitKey;
        }
        for (int i2 = 0; i2 < 2; ++i2) {
            EntityNPCInterface dNpc;
            EntityNPCInterface entityNPCInterface = dNpc = i2 == 0 ? this.npcAnim : this.npcPart;
            if (dNpc == null) continue;
            dNpc.animation.updateTime();
            dNpc.field_20061_w = this.npc.field_20061_w;
            dNpc.field_20062_v = this.npc.field_20062_v;
            dNpc.field_20063_u = this.npc.field_20063_u;
            dNpc.field_20064_t = this.npc.field_20064_t;
            dNpc.field_20065_s = this.npc.field_20065_s;
            dNpc.field_20066_r = this.npc.field_20066_r;
            dNpc.field_70173_aa = this.npc.field_70173_aa;
        }
        for (Entity e : this.environmentEntitys) {
            e.field_70173_aa = this.npc.field_70173_aa;
        }
        if (this.getDisplayNpc() == null) {
            this.close();
        }
        EntityNPCInterface showNPC = this.getDisplayNpc();
        if (this.getLabel(50) != null) {
            label = (GuiNpcLabel)this.getLabel(50);
            int cId = showNPC.animation.getAnimationCurrentFrameID();
            int nId = showNPC.animation.getAnimationNextFrameID();
            String frame = new TextComponentTranslation("animation.frame", new Object[]{" ID: "}).func_150254_d();
            if (cId == nId) {
                label.setLabel(frame + '\u00a7' + "6" + cId);
            } else {
                label.setLabel(frame + '\u00a7' + "6" + cId + '\u00a7' + "r -> " + '\u00a7' + "6" + nId);
            }
        }
        if (this.getLabel(51) != null) {
            label = (GuiNpcLabel)this.getLabel(51);
            EnumAnimationStages stage = showNPC.animation.getAnimationStage();
            int t = showNPC.animation.getAnimationTicks();
            int s = showNPC.animation.getAnimationSpeedTicks();
            String data = "\u00a76" + t + '\u00a7' + "r/" + '\u00a7' + "6" + s;
            switch (stage) {
                case Started: {
                    data = data + " \u00a7aStarted";
                    break;
                }
                case Looping: {
                    data = data + " \u00a7bLooping";
                    break;
                }
                case Run: {
                    data = data + " \u00a7eRun";
                    break;
                }
                case Ending: {
                    data = data + " \u00a7dEnding";
                    break;
                }
                case Waiting: {
                    data = data + " \u00a7cWaiting";
                }
            }
            label.setLabel(data);
            label.x = this.workU + this.workS / 2 - 13 - label.width;
        }
        if (Mouse.isButtonDown((int)this.mousePressId)) {
            int x = mouseX - this.mousePressX;
            y = mouseY - this.mousePressY;
            if (x != 0 || y != 0) {
                if (this.mousePressId == 0) {
                    this.displayOffset(x, y);
                } else if (this.mousePressId == 1) {
                    this.displayRotate(x, -y);
                }
                this.mousePressX = mouseX;
                this.mousePressY = mouseY;
            }
        } else {
            this.mousePressId = -1;
        }
        this.hovered = this.isMouseHover(mouseX, mouseY, this.workU + 1, this.workV + 1, this.workS - 2, this.workS - 2);
        if (!(!this.hovered || this.tools != null && this.tools.hovered || this.partNames != null && this.partNames.hovered || (dWheel = Mouse.getDWheel()) == 0)) {
            this.dispScale += this.dispScale * (dWheel < 0 ? 0.1f : -0.1f);
            if (this.dispScale < 0.5f) {
                this.dispScale = 0.5f;
            } else if (this.dispScale > 10.0f) {
                this.dispScale = 10.0f;
            }
            this.dispScale = (float)((double)Math.round((double)this.dispScale * 20.0) / 20.0);
            if (this.dispScale == 0.95f || this.dispScale == 1.05f) {
                this.dispScale = 1.0f;
            }
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-300.0f);
        int color = new Color(-3750202).getRGB();
        this.func_73733_a(this.winU + 1, this.winV + 1, this.winU + this.winW - 1, this.winV + this.winH - 1, color, color);
        color = new Color(-16777216).getRGB();
        this.func_73730_a(this.winU + 1, this.winU + this.winW - 2, this.winV, color);
        this.func_73728_b(this.winU, this.winV, this.winV + this.winH - 1, color);
        this.func_73728_b(this.winU + this.winW - 1, this.winV, this.winV + this.winH - 1, color);
        this.func_73730_a(this.winU + 1, this.winU + this.winW - 2, this.winV + this.winH - 1, color);
        color = GuiNpcAnimation.backColor == -16777216 ? new Color(-1015568).getRGB() : new Color(-1040144).getRGB();
        this.func_73733_a(this.workU, this.workV, this.workU + this.workS, this.workV + this.workS, color, color);
        y = 86 + (this.hasExtend ? 14 : 0);
        GlStateManager.func_179094_E();
        this.field_146297_k.func_110434_K().func_110577_a(GuiNPCInterface.RESOURCE_SLOT);
        GlStateManager.func_179109_b((float)(this.winU + 3), (float)(this.winV + y), (float)0.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(0, 0, 0, 0, 18, 18);
        switch (this.frame.getHoldRightStackType()) {
            case 1: {
                stack = this.npc.inventory.getProjectile();
                break;
            }
            case 2: {
                stack = this.npc.inventory.getLeftHand();
                break;
            }
            case 3: {
                stack = this.frame.getHoldRightStack();
                break;
            }
            case 4: {
                stack = this.npc.inventory.getArmor(0);
                break;
            }
            case 5: {
                stack = this.npc.inventory.getArmor(1);
                break;
            }
            case 6: {
                stack = this.npc.inventory.getArmor(2);
                break;
            }
            case 7: {
                stack = this.npc.inventory.getArmor(3);
                break;
            }
            default: {
                stack = this.npc.inventory.getRightHand();
            }
        }
        this.hoverRight = this.isMouseHover(mouseX, mouseY, this.winU + 3, this.winV + y + 1, 16, 16);
        if (this.hoverRight) {
            Gui.func_73734_a((int)1, (int)1, (int)17, (int)17, (int)new Color(-2130706433).getRGB());
            if (stack != null && !stack.isEmpty() && !(list = stack.getMCItemStack().func_82840_a((EntityPlayer)this.player, (ITooltipFlag)(this.field_146297_k.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL))).isEmpty()) {
                this.setHoverText(list);
            }
        }
        if (stack != null && !stack.isEmpty()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)1.0f, (float)1.0f, (float)0.0f);
            RenderHelper.func_74519_b();
            this.field_146297_k.func_175599_af().func_180450_b(stack.getMCItemStack(), 0, 0);
            RenderHelper.func_74518_a();
            GlStateManager.func_179121_F();
        }
        y += 20;
        this.field_146297_k.func_110434_K().func_110577_a(GuiNPCInterface.RESOURCE_SLOT);
        GlStateManager.func_179109_b((float)0.0f, (float)20.0f, (float)0.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(0, 0, 0, 0, 18, 18);
        switch (this.frame.getHoldLeftStackType()) {
            case 1: {
                stack = this.npc.inventory.getProjectile();
                break;
            }
            case 2: {
                stack = this.npc.inventory.getRightHand();
                break;
            }
            case 3: {
                stack = this.frame.getHoldLeftStack();
                break;
            }
            case 4: {
                stack = this.npc.inventory.getArmor(0);
                break;
            }
            case 5: {
                stack = this.npc.inventory.getArmor(1);
                break;
            }
            case 6: {
                stack = this.npc.inventory.getArmor(2);
                break;
            }
            case 7: {
                stack = this.npc.inventory.getArmor(3);
                break;
            }
            default: {
                stack = this.npc.inventory.getLeftHand();
            }
        }
        this.hoverLeft = this.isMouseHover(mouseX, mouseY, this.winU + 3, this.winV + y + 1, 16, 16);
        if (this.hoverLeft) {
            Gui.func_73734_a((int)1, (int)1, (int)17, (int)17, (int)new Color(-2130706433).getRGB());
            if (stack != null && !stack.isEmpty() && !(list = stack.getMCItemStack().func_82840_a((EntityPlayer)this.player, (ITooltipFlag)(this.field_146297_k.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL))).isEmpty()) {
                this.setHoverText(list);
            }
        }
        if (stack != null && !stack.isEmpty()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)1.0f, (float)1.0f, (float)0.0f);
            RenderHelper.func_74519_b();
            this.field_146297_k.func_175599_af().func_180450_b(stack.getMCItemStack(), 0, 0);
            RenderHelper.func_74518_a();
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179121_F();
        y -= 80 + (this.hasExtend ? 14 : 0);
        color = new Color(-16777216).getRGB();
        for (i = 0; i < 17; ++i) {
            this.func_73730_a(this.winU + 4 + i * 8, this.winU + 8 + i * 8, this.winV + y, color);
        }
        y += 23;
        for (i = 0; i < 17; ++i) {
            this.func_73730_a(this.winU + 4 + i * 8, this.winU + 8 + i * 8, this.winV + y, color);
        }
        y += 76 + (this.hasExtend ? 14 : 0);
        for (i = 0; i < 17; ++i) {
            this.func_73730_a(this.winU + 4 + i * 8, this.winU + 8 + i * 8, this.winV + y, color);
        }
        y += 38;
        for (i = 0; i < 17; ++i) {
            this.func_73730_a(this.winU + 4 + i * 8, this.winU + 8 + i * 8, this.winV + y, color);
        }
        y += 17;
        for (i = 0; i < 17; ++i) {
            this.func_73730_a(this.winU + 4 + i * 8, this.winU + 8 + i * 8, this.winV + y, color);
        }
        y += 26;
        for (i = 0; i < 17; ++i) {
            this.func_73730_a(this.winU + 4 + i * 8, this.winU + 8 + i * 8, this.winV + y, color);
        }
        y += 26;
        for (i = 0; i < 17; ++i) {
            this.func_73730_a(this.winU + 4 + i * 8, this.winU + 8 + i * 8, this.winV + y, color);
        }
        y += 25;
        for (i = 0; i < 17; ++i) {
            this.func_73730_a(this.winU + 4 + i * 8, this.winU + 8 + i * 8, this.winV + y, color);
        }
        GlStateManager.func_179121_F();
        if (this.subgui == null) {
            GlStateManager.func_179094_E();
            GL11.glEnable((int)3089);
            int c = this.w < (double)this.field_146297_k.field_71443_c ? (int)Math.round((double)this.field_146297_k.field_71443_c / this.w) : 1;
            GL11.glScissor((int)((this.workU + 1) * c), (int)(this.field_146297_k.field_71440_d - (this.workV + this.workS - 1) * c), (int)((this.workS - 2) * c), (int)((this.workS - 2) * c));
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.drawWork(partialTicks);
            GL11.glDisable((int)3089);
            GlStateManager.func_179121_F();
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)950.0f);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)((float)this.workU + 12.5f), (float)((float)this.workV + 12.0f), (float)(this.dispScale > 1.0f ? -240.0f : 0.0f));
            if (this.dispRot[0] != 0.0f) {
                GlStateManager.func_179114_b((float)this.dispRot[0], (float)0.0f, (float)1.0f, (float)0.0f);
            }
            if (this.dispRot[1] != 0.0f) {
                GlStateManager.func_179114_b((float)this.dispRot[1], (float)0.0f, (float)0.0f, (float)1.0f);
            }
            if (this.dispRot[2] != 0.0f) {
                GlStateManager.func_179114_b((float)this.dispRot[2], (float)1.0f, (float)0.0f, (float)0.0f);
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.5f);
            this.drawCRect(-10.5, -0.5, -0.5, 0.5, new Color(-16776961).getRGB());
            GlStateManager.func_179121_F();
            GlStateManager.func_179094_E();
            this.drawCRect(-10.5, -0.5, -0.5, 0.5, new Color(-65536).getRGB());
            this.drawCRect(-0.5, -10.5, 0.5, -0.5, new Color(-16723968).getRGB());
            color = GuiNpcAnimation.backColor == -16777216 ? new Color(-1).getRGB() : new Color(-16777216).getRGB();
            this.drawCRect(-0.5, -0.5, 0.5, 0.5, color);
            GlStateManager.func_179121_F();
            GlStateManager.func_179121_F();
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)this.workU, (float)this.workV, (float)0.0f);
            String ts = "x" + this.dispScale;
            this.field_146289_q.func_175065_a(ts, (float)(this.workS - 11 - this.field_146289_q.func_78256_a(ts)), 1.0f, color, false);
            ts = (int)this.dispRot[0] + "" + '\u00b0' + "/" + (int)this.dispRot[1] + '\u00b0' + "/" + (int)this.dispRot[2] + '\u00b0';
            this.field_146289_q.func_175065_a(ts, (float)(this.workS - 11 - this.field_146289_q.func_78256_a(ts)), (float)(this.workS - 10), color, false);
            ts = (int)this.dispPos[0] + "/" + (int)this.dispPos[1];
            this.field_146289_q.func_175065_a(ts, 11.0f, (float)(this.workS - 10), color, false);
            GlStateManager.func_179121_F();
            GlStateManager.func_179121_F();
        } else {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)1.0f);
            Gui.func_73734_a((int)(this.workU + 1), (int)(this.workV + 1), (int)(this.workU + this.workS - 1), (int)(this.workV + this.workS - 1), (int)GuiNpcAnimation.backColor);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179094_E();
        this.translateZ = 975.0f;
        super.func_73863_a(mouseX, mouseY, partialTicks);
        GlStateManager.func_179121_F();
        this.getButton(7).setEnabled(!this.isMotion && (this.isHitbox && this.hitbox != null || this.anim != null && this.part != null && this.part.id != 6 && this.part.id != 7));
        this.getButton(8).setEnabled(!this.isMotion && (this.isHitbox && this.hitbox != null || this.anim != null && this.addedPartConfig != null && this.part != null && this.part.id > 7));
        if (this.hasSubGui() || !CustomNpcs.ShowDescriptions) {
            return;
        }
        this.drawHoverText(null, new Object[0]);
    }

    @Override
    public void setMiniHoverText(int id, IComponentGui c) {
        if (id < 0) {
            return;
        }
        if (c instanceof GuiNpcSlider) {
            switch (((GuiNpcSlider)c).field_146127_k) {
                case 0: {
                    if (this.isHitbox || this.isMotion) {
                        this.setHoverText(new TextComponentTranslation("animation.hover." + (this.toolType == 1 ? "offset.d" : "scale.hb"), new Object[]{"X"}).func_150254_d(), new Object[0]);
                        break;
                    }
                    this.setHoverText(new TextComponentTranslation("animation.hover." + (this.toolType == 0 ? "rotation" : (this.toolType == 1 ? "offset" : "scale")), new Object[]{"X"}).func_150254_d(), new Object[0]);
                    break;
                }
                case 1: {
                    if (this.isHitbox || this.isMotion) {
                        this.setHoverText(new TextComponentTranslation("animation.hover." + (this.toolType == 1 ? "offset.h" : "scale.hb"), new Object[]{"Y"}).func_150254_d(), new Object[0]);
                        break;
                    }
                    this.setHoverText(new TextComponentTranslation("animation.hover." + (this.toolType == 0 ? "rotation" : (this.toolType == 1 ? "offset" : "scale")), new Object[]{"Y"}).func_150254_d(), new Object[0]);
                    break;
                }
                case 2: {
                    if (this.isHitbox || this.isMotion) {
                        this.setHoverText(new TextComponentTranslation("animation.hover." + (this.toolType == 1 ? "offset.w" : "scale.hb"), new Object[]{"Z"}).func_150254_d(), new Object[0]);
                        break;
                    }
                    this.setHoverText(new TextComponentTranslation("animation.hover." + (this.toolType == 0 ? "rotation" : (this.toolType == 1 ? "offset" : "scale")), new Object[]{"Z"}).func_150254_d(), new Object[0]);
                    break;
                }
                case 3: {
                    this.setHoverText(new TextComponentTranslation("animation.hover.rotation", new Object[]{"X1"}).func_150254_d(), new Object[0]);
                    break;
                }
                case 4: {
                    this.setHoverText(new TextComponentTranslation("animation.hover.rotation", new Object[]{"Y1"}).func_150254_d(), new Object[0]);
                }
            }
        } else if (c instanceof GuiNpcTextField) {
            TextComponentTranslation text = null;
            switch (((GuiNpcTextField)c).func_175206_d()) {
                case 5: {
                    if (this.isHitbox || this.isMotion) {
                        text = new TextComponentTranslation("animation.hover." + (this.toolType == 1 ? "offset.d" : "scale.hb"), new Object[]{"X"});
                        break;
                    }
                    text = new TextComponentTranslation("animation.hover." + (this.toolType == 0 ? "rotation" : (this.toolType == 1 ? "offset" : "scale")), new Object[]{"X"});
                    break;
                }
                case 6: {
                    if (this.isHitbox || this.isMotion) {
                        text = new TextComponentTranslation("animation.hover." + (this.toolType == 1 ? "offset.h" : "scale.hb"), new Object[]{"Y"});
                        break;
                    }
                    text = new TextComponentTranslation("animation.hover." + (this.toolType == 0 ? "rotation" : (this.toolType == 1 ? "offset" : "scale")), new Object[]{"Y"});
                    break;
                }
                case 7: {
                    if (this.isHitbox || this.isMotion) {
                        text = new TextComponentTranslation("animation.hover." + (this.toolType == 1 ? "offset.w" : "scale.hb"), new Object[]{"Z"});
                        break;
                    }
                    text = new TextComponentTranslation("animation.hover." + (this.toolType == 0 ? "rotation" : (this.toolType == 1 ? "offset" : "scale")), new Object[]{"Z"});
                    break;
                }
                case 8: {
                    text = new TextComponentTranslation("animation.hover.rotation", new Object[]{"X1"});
                    break;
                }
                case 9: {
                    text = new TextComponentTranslation("animation.hover.rotation", new Object[]{"Y1"});
                }
            }
            if (text != null) {
                text.func_150257_a((ITextComponent)new TextComponentTranslation("animation.hover.tab", new Object[0]));
                this.setHoverText(text.func_150254_d(), new Object[0]);
            }
        } else if (c instanceof GuiNpcButton) {
            if (((GuiNpcButton)c).field_146127_k == 48) {
                this.setHoverText(new TextComponentTranslation("animation.hover.show.motion", new Object[0]).func_150254_d(), new Object[0]);
            } else {
                this.setHoverText(new TextComponentTranslation("hover.default.set", new Object[0]).func_150254_d(), new Object[0]);
            }
        } else if (c instanceof GuiCustomScroll) {
            Map<Integer, List<String>> hts = ((GuiCustomScroll)c).getHoversTexts();
            if (hts.containsKey(((GuiCustomScroll)c).hover) && !hts.get(((GuiCustomScroll)c).hover).isEmpty()) {
                this.setHoverText(hts.get(((GuiCustomScroll)c).hover));
            } else if (!((GuiCustomScroll)c).getHoversText().isEmpty()) {
                this.setHoverText(((GuiCustomScroll)c).getHoversText());
            }
        }
    }

    private void drawWork(float partialTicks) {
        IBlockState state;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-300.0f);
        Gui.func_73734_a((int)(this.workU + 1), (int)(this.workV + 1), (int)(this.workU + this.workS - 1), (int)(this.workV + this.workS - 1), (int)GuiNpcAnimation.backColor);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        this.postRender();
        switch (this.blockType) {
            case 1: {
                state = Blocks.field_150350_a.func_176223_P();
                break;
            }
            case 3: {
                state = Blocks.field_150446_ar.func_176223_P();
                break;
            }
            case 4: {
                state = Blocks.field_150333_U.func_176223_P();
                break;
            }
            case 5: {
                state = Blocks.field_150404_cg.func_176223_P();
                break;
            }
            default: {
                state = Blocks.field_150348_b.func_176223_P();
            }
        }
        this.field_146297_k.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        this.field_146297_k.func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
        GlStateManager.func_179091_B();
        GlStateManager.func_179141_d();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float ytr = this.offsetY;
        GlStateManager.func_179109_b((float)(-8.0f * this.winScale), (float)(ytr * this.winScale), (float)(8.0f * this.winScale));
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)-16.0f, (float)-16.0f, (float)-16.0f);
        GlStateManager.func_179152_a((float)this.winScale, (float)this.winScale, (float)this.winScale);
        int yH = this.blockType == 0 ? this.blockSize : 0;
        HashMap<BlockPos, Object> tiles = new HashMap<BlockPos, Object>();
        for (int y = -yH; y <= yH; ++y) {
            for (int x = -this.blockSize; x <= this.blockSize; ++x) {
                for (int z = -this.blockSize; z <= this.blockSize; ++z) {
                    TileEntitySpecialRenderer render;
                    BlockPos pos = new BlockPos(x, y + (this.blockSize == 0 ? 0 : 1), z);
                    Object tile = null;
                    if (this.blockType == 0) {
                        TileEntity t;
                        IBlockState s = this.environmentStates.get(pos);
                        if (s != null) {
                            state = s;
                        }
                        if ((t = this.environmentTiles.get(pos)) != null) {
                            tile = t;
                        }
                    }
                    if (tile != null && (render = (TileEntitySpecialRenderer)TileEntityRendererDispatcher.field_147556_a.field_147559_m.get(tile.getClass())) != null) {
                        tiles.put(pos, tile);
                        continue;
                    }
                    if (state.func_177230_c() instanceof BlockAir) continue;
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GlStateManager.func_179109_b((float)x, (float)(y - (this.blockSize == 0 || this.blockType > 1 ? 1 : 0)), (float)z);
                    if (this.blockType == 4) {
                        GlStateManager.func_179109_b((float)0.0f, (float)0.5f, (float)0.0f);
                    } else if (this.blockType == 5) {
                        GlStateManager.func_179109_b((float)0.0f, (float)0.9375f, (float)0.0f);
                    }
                    this.field_146297_k.func_175602_ab().func_175016_a(state, 1.0f);
                    GlStateManager.func_179121_F();
                }
            }
        }
        for (BlockPos p : tiles.keySet()) {
            try {
                TileEntity tile = (TileEntity)tiles.get(p);
                TileEntitySpecialRenderer render = (TileEntitySpecialRenderer)TileEntityRendererDispatcher.field_147556_a.field_147559_m.get(tile.getClass());
                if (render == null) continue;
                GlStateManager.func_179094_E();
                render.func_192841_a(tile, (double)p.func_177958_n(), (double)p.func_177956_o() - 1.0, (double)(p.func_177952_p() - 1), partialTicks, 0, 1.0f);
                GlStateManager.func_179121_F();
            }
            catch (Exception tile) {}
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-1.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (meshType == 0) {
            this.drawLine(0.0, 0.0, 0.0, 10.0, 0, 1.0f, 0.0f, 0.0f);
            this.drawLine(0.0, 0.0, 0.0, 10.0, 1, 0.0f, 1.0f, 0.0f);
            this.drawLine(0.0, 0.0, 0.0, 10.0, 2, 0.0f, 0.0f, 1.0f);
        } else if (meshType == 1) {
            this.drawLine(0.0, 0.0, -11.0, 11.0, 0, 1.0f, 1.0f, 1.0f);
            this.drawLine(-11.0, 0.0, 0.0, 11.0, 2, 1.0f, 1.0f, 1.0f);
            for (int i = -10; i <= 11; ++i) {
                this.drawLine(0.0, 0.0, i, 11.0, 0, 1.0f, 1.0f, 1.0f);
                this.drawLine(i, 0.0, 0.0, 11.0, 2, 1.0f, 1.0f, 1.0f);
            }
        } else if (meshType == 2) {
            this.drawLine(0.0, -11.0, 0.0, 11.0, 0, 1.0f, 1.0f, 1.0f);
            this.drawLine(-11.0, 0.0, 0.0, 11.0, 1, 1.0f, 1.0f, 1.0f);
            for (int i = -10; i <= 11; ++i) {
                this.drawLine(0.0, i, 0.0, 11.0, 0, 1.0f, 1.0f, 1.0f);
                this.drawLine(i, 0.0, 0.0, 11.0, 1, 1.0f, 1.0f, 1.0f);
            }
        } else if (meshType == 3) {
            this.drawLine(0.0, 0.0, -11.0, 11.0, 1, 1.0f, 1.0f, 1.0f);
            this.drawLine(0.0, -11.0, 0.0, 11.0, 2, 1.0f, 1.0f, 1.0f);
            for (int i = -10; i <= 11; ++i) {
                this.drawLine(0.0, 0.0, i, 11.0, 1, 1.0f, 1.0f, 1.0f);
                this.drawLine(0.0, i, 0.0, 11.0, 2, 1.0f, 1.0f, 1.0f);
            }
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
        GlStateManager.func_179141_d();
        GlStateManager.func_179101_C();
        GlStateManager.func_179140_f();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179142_g();
        GlStateManager.func_179109_b((float)0.5f, (float)0.0f, (float)-0.5f);
        this.field_146297_k.func_175598_ae().field_78735_i = 180.0f;
        EntityNPCInterface showNPC = this.getDisplayNpc();
        if (this.npc.ais.bodyOffsetX != 5.0f) {
            float f = (this.npc.ais.bodyOffsetX - 5.0f) / 10.0f;
            if (f == 0.5f) {
                f -= 1.0f;
            }
            GlStateManager.func_179109_b((float)f, (float)0.0f, (float)0.0f);
        }
        if (this.npc.ais.bodyOffsetZ != 5.0f) {
            float f = (this.npc.ais.bodyOffsetZ - 5.0f) / 10.0f;
            if (f == 0.5f) {
                f -= 1.0f;
            }
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)f);
        }
        if (showHitBox) {
            float w = this.npc.field_70130_N / 2.0f;
            AxisAlignedBB col = this.npc.func_70046_E();
            if (col == null) {
                col = new AxisAlignedBB((double)(-w), 0.0, (double)(-w), (double)w, (double)this.npc.field_70131_O, (double)w);
            }
            GlStateManager.func_187441_d((float)1.0f);
            GlStateManager.func_179090_x();
            RenderGlobal.func_189697_a((AxisAlignedBB)col, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179098_w();
        }
        if (this.anim.type == AnimationKind.ATTACKING && this.frame.isNowDamage() && !this.frame.damageHitboxes.isEmpty()) {
            GlStateManager.func_187441_d((float)2.0f);
            GlStateManager.func_179090_x();
            int i = 0;
            for (AxisAlignedBB aabb : this.anim.getDamageHitboxes((EntityLivingBase)showNPC, this.frame.id)) {
                float r = 0.75f;
                float g = 0.5f;
                float b = 0.5f;
                float s = 1.0f;
                if (this.scrollHitboxes.getSelect() == i) {
                    r = 1.0f;
                    g = 0.0f;
                    b = 0.25f;
                    s = 2.0f;
                }
                if (this.scrollHitboxes.hover == i) {
                    r = 0.875f;
                    g = 0.0f;
                    b = 0.875f;
                    s = 3.0f;
                }
                aabb = aabb.func_72317_d(-showNPC.field_70165_t, -showNPC.field_70163_u, -showNPC.field_70161_v);
                GlStateManager.func_187441_d((float)s);
                RenderGlobal.func_189697_a((AxisAlignedBB)aabb, (float)r, (float)g, (float)b, (float)1.0f);
                Vec3d center = aabb.func_189972_c();
                for (int j = 0; j < 3; ++j) {
                    AnimationDamageHitbox adh = this.frame.damageHitboxes.get(i);
                    s = 0.1f;
                    if (adh != null) {
                        s *= adh.scale[j];
                    }
                    this.drawLine(center.field_72450_a, center.field_72448_b, center.field_72449_c, ValueUtil.correctDouble(s, 0.025, 0.25), j, b, r, g);
                }
                if (this.scrollHitboxes.getSelect() == i) {
                    r = 0.5f;
                    g = 0.5f;
                    b = 0.5f;
                    s = 1.0f;
                    if (this.tools.getSlider(0).isHovered() || this.tools.getTextField(5).isHovered() || ((GuiNpcTextField)this.tools.getTextField(5)).func_146206_l() || this.tools.getButton(30).isHovered()) {
                        r = 0.825f;
                        g = 0.625f;
                        b = 0.195f;
                        s = 3.0f;
                    }
                    this.drawLine(0.0, 0.0, center.field_72450_a, 0.0, center.field_72449_c, s, r, g, b);
                    r = 0.5f;
                    g = 0.5f;
                    b = 0.5f;
                    s = 1.0f;
                    if (this.tools.getSlider(1).isHovered() || this.tools.getTextField(6).isHovered() || ((GuiNpcTextField)this.tools.getTextField(6)).func_146206_l() || this.tools.getButton(31).isHovered()) {
                        r = 0.825f;
                        g = 0.625f;
                        b = 0.195f;
                        s = 3.0f;
                    }
                    this.drawLine(center.field_72450_a, center.field_72449_c, center.field_72450_a, center.field_72448_b, center.field_72449_c, s, r, g, b);
                    r = 0.5f;
                    g = 0.5f;
                    b = 0.5f;
                    s = 1.0f;
                    if (this.tools.getSlider(2).isHovered() || this.tools.getTextField(7).isHovered() || ((GuiNpcTextField)this.tools.getTextField(7)).func_146206_l() || this.tools.getButton(32).isHovered()) {
                        r = 0.825f;
                        g = 0.625f;
                        b = 0.195f;
                        s = 3.0f;
                    }
                    this.drawCircle(Math.sqrt(Math.pow(center.field_72450_a, 2.0) + Math.pow(center.field_72449_c, 2.0)), s, r, g, b);
                }
                ++i;
            }
            GlStateManager.func_179098_w();
        }
        if (this.frame.motions[0] != 0.0f || this.frame.motions[1] != 0.0f || this.frame.motions[2] != 0.0f) {
            double radYaw = Math.toRadians(showNPC.field_70177_z) + (double)this.frame.motions[2];
            double x = Math.sin(radYaw) * (double)(-this.frame.motions[0]);
            double y = this.frame.motions[1];
            double z = Math.cos(radYaw) * (double)this.frame.motions[0];
            float r = 0.5f;
            float g = 0.5f;
            float b = 0.75f;
            float s = 2.0f;
            if (this.isMotion) {
                b = 0.5f;
                if (this.tools.getSlider(0).isHovered() || this.tools.getTextField(5).isHovered() || ((GuiNpcTextField)this.tools.getTextField(5)).func_146206_l() || this.tools.getButton(30).isHovered()) {
                    r = 0.825f;
                    g = 0.625f;
                    b = 0.195f;
                    s = 3.0f;
                }
                this.drawLine(0.0, 0.0, x, 0.0, z, s, r, g, b);
                r = 0.5f;
                g = 0.5f;
                b = 0.5f;
                s = 1.0f;
                if (this.tools.getSlider(1).isHovered() || this.tools.getTextField(6).isHovered() || ((GuiNpcTextField)this.tools.getTextField(6)).func_146206_l() || this.tools.getButton(31).isHovered()) {
                    r = 0.825f;
                    g = 0.625f;
                    b = 0.195f;
                    s = 3.0f;
                }
                this.drawLine(x, z, x, y, z, s, r, g, b);
                r = 0.5f;
                g = 0.5f;
                b = 0.5f;
                s = 1.0f;
                if (this.tools.getSlider(2).isHovered() || this.tools.getTextField(7).isHovered() || ((GuiNpcTextField)this.tools.getTextField(7)).func_146206_l() || this.tools.getButton(32).isHovered()) {
                    r = 0.825f;
                    g = 0.625f;
                    b = 0.195f;
                    s = 3.0f;
                }
                this.drawCircle(Math.sqrt(Math.pow(x, 2.0) + Math.pow(z, 2.0)), s, r, g, b);
                r = 0.25f;
                g = 0.25f;
                b = 0.875f;
                s = 3.0f;
            }
            double radius = Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0) + Math.pow(z, 2.0));
            GlStateManager.func_179094_E();
            GlStateManager.func_179114_b((float)((float)Math.toDegrees(-radYaw)), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)((float)Math.toDegrees(-Math.atan2(this.frame.motions[1], this.frame.motions[0]))), (float)1.0f, (float)0.0f, (float)0.0f);
            this.drawArrow(radius, s, r, g, b);
            GlStateManager.func_179121_F();
        }
        ModelNpcAlt.editAnimDataSelect.displayNpc = showNPC;
        float r = showNPC.field_70177_z < 0.0f ? showNPC.field_70177_z + 360.0f : showNPC.field_70177_z;
        float oy = 0.0f;
        showNPC.currentAnimation = this.npc.currentAnimation;
        this.field_146297_k.func_175598_ae().func_188391_a((Entity)showNPC, 0.0, (double)oy, 0.0, 0.0f, r / -45.0f + 8.0f, false);
        if (this.blockType == 0) {
            for (Entity e : this.environmentEntitys) {
                int x = Math.abs((int)Math.round(e.field_70165_t));
                int y = Math.abs((int)Math.round(e.field_70163_u));
                int z = Math.abs((int)Math.round(e.field_70161_v));
                int d = x;
                if (d < y) {
                    d = y;
                }
                if (d < z) {
                    d = z;
                }
                if (d > this.blockSize) continue;
                GlStateManager.func_179094_E();
                this.field_146297_k.func_175598_ae().func_188391_a(e, e.field_70165_t, e.field_70163_u, e.field_70161_v, 0.0f, 0.0f, false);
                GlStateManager.func_179121_F();
            }
        }
        GlStateManager.func_179101_C();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_179140_f();
        GlStateManager.func_179121_F();
    }

    public EntityNPCInterface getDisplayNpc() {
        return this.onlyCurrentPart ? this.npcPart : this.npcAnim;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.frame.id < 0) {
            this.frame = this.anim.frames.get(0);
            if (this.frame.id < 0) {
                this.frame.id = 0;
            }
        }
        if (this.hitbox.id < 0) {
            this.hitbox = this.frame.damageHitboxes.get(0);
            if (this.hitbox.id < 0) {
                this.hitbox.id = 0;
            }
        }
        if (this.scrollParts == null) {
            this.scrollParts = new GuiCustomScroll(this, 0);
            this.scrollParts.setSize(67, 112);
            this.scrollParts.setHoverText("animation.hover.part.sel", new Object[0]);
        }
        ScaledResolution sw = new ScaledResolution(this.field_146297_k);
        if (this.w > 0.0 && this.h > 0.0) {
            double top;
            double left;
            if (this.partNames != null) {
                left = 1.0 / this.w * (double)this.partNames.guiLeft;
                top = 1.0 / this.h * (double)this.partNames.guiTop;
                this.partNames.guiLeft = (int)((double)sw.func_78326_a() * left);
                this.partNames.guiTop = (int)((double)sw.func_78328_b() * top);
                this.scrollParts.guiLeft = this.partNames.guiLeft + 4;
                this.scrollParts.guiTop = this.partNames.guiTop + 12;
            }
            if (this.tools != null) {
                left = 1.0 / this.w * (double)this.tools.guiLeft;
                top = 1.0 / this.h * (double)this.tools.guiTop;
                this.tools.guiLeft = (int)((double)sw.func_78326_a() * left);
                this.tools.guiTop = (int)((double)sw.func_78328_b() * top);
            }
        }
        this.w = sw.func_78326_a();
        this.h = sw.func_78328_b();
        if (sw.func_78326_a() - 144 < sw.func_78328_b() - 8) {
            this.workS = sw.func_78326_a() - 144;
            this.winU = 0;
            this.winW = sw.func_78326_a();
            this.winV = (sw.func_78328_b() - this.workS - 8) / 2;
            this.winH = this.workS + 8;
        } else {
            this.workS = sw.func_78328_b() - 8;
            this.winU = (sw.func_78326_a() - this.workS - 144) / 2;
            this.winW = this.workS + 144;
            this.winV = 0;
            this.winH = sw.func_78328_b();
        }
        this.workU = this.winU + 140;
        this.workV = this.winV + 4;
        this.winScale = (float)this.workS / 100.0f;
        int x = this.winU + 3;
        int y = this.winV + 12;
        int lId = 0;
        GuiNpcLabel label = new GuiNpcLabel(lId++, "\u00a7n\u00a7l?", this.workU - 6, this.workV, -16777216);
        label.setHoverText("animation.hover.help", new Object[0]);
        this.addLabel(label);
        this.addLabel(new GuiNpcLabel(lId++, new TextComponentTranslation("gui.name", new Object[0]).func_150254_d() + ":", x, y - 10));
        GuiNpcTextField textField = new GuiNpcTextField(11, this, x, y, 125, 12, this.anim.name);
        this.addTextField(textField);
        label = new GuiNpcLabel(lId++, this.anim.getSettingName(), this.workU + this.workS / 2, this.workV + 3, GuiNpcAnimation.backColor == -16777216 ? -1 : -16777216);
        label.setCenter(label.width / 2);
        this.addLabel(label);
        this.addLabel(new GuiNpcLabel(lId++, "animation.place", x, (y += 26) - 10));
        GuiNpcButton button = new GuiButtonBiDirectional(0, x, y, 105, 10, this.blockNames, this.blockType);
        button.setHoverText("animation.hover.block.type", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(1, x + 107, y, 17, 10, this.blockSizes, this.blockSize);
        button.texture = ANIMATION_BUTTONS;
        button.hasDefBack = false;
        button.isAnim = true;
        button.txrY = 96;
        button.setHoverText("animation.hover.block.size", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(2, this.workU + 2, this.workV + 23, 8, 8, "");
        button.layerColor = GuiNpcAnimation.backColor == -16777216 ? new Color(-16711681).getRGB() : new Color(-16744320).getRGB();
        button.texture = ANIMATION_BUTTONS;
        button.hasDefBack = false;
        button.isAnim = true;
        button.txrY = 96;
        button.setHoverText("animation.hover.color", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(26, this.workU + 2, this.workV + 31, 8, 8, "");
        button.layerColor = ModelNpcAlt.editAnimDataSelect.showArmor ? new Color(-36352).getRGB() : new Color(-9489920).getRGB();
        button.texture = ANIMATION_BUTTONS;
        button.hasDefBack = false;
        button.isAnim = true;
        button.txrY = 96;
        button.setHoverText("animation.hover.show.armor", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(46, this.workU + 2, this.workV + 39, 8, 8, "");
        button.layerColor = ModelNpcAlt.editAnimDataSelect.alpha >= 1.0f ? new Color(-321).getRGB() : new Color(-8882344).getRGB();
        button.texture = ANIMATION_BUTTONS;
        button.hasDefBack = false;
        button.isAnim = true;
        button.txrY = 96;
        button.setHoverText("animation.hover.show.alpha", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(47, this.workU + 2, this.workV + 47, 8, 8, "");
        button.layerColor = GuiNpcAnimation.backColor == -16777216 ? new Color(-16711681).getRGB() : new Color(-16744320).getRGB();
        button.layerColor = this.baseRotation == 0.0f || this.baseRotation == this.npcAnim.field_70177_z ? -6881344 : -12424109;
        button.texture = ANIMATION_BUTTONS;
        button.hasDefBack = false;
        button.isAnim = true;
        button.txrY = 96;
        button.setHoverText("animation.hover.base.rot", new Object[0]);
        this.addButton(button);
        this.addLabel(new GuiNpcLabel(lId++, "animation.frames", x, (y += 23) - 10));
        ArrayList<String> lFrames = new ArrayList<String>();
        for (int i = 0; i < this.anim.frames.size(); ++i) {
            lFrames.add(i + "/" + (this.anim.frames.size() - 1));
        }
        button = new GuiButtonBiDirectional(3, x, y, 60, 10, lFrames.toArray(new String[0]), this.frame.id);
        button.setHoverText("animation.hover.frame", "" + (this.frame.id + 1));
        this.addButton(button);
        button = new GuiNpcButton(4, x + 106, y - 10, 10, 10, "");
        button.texture = ANIMATION_BUTTONS;
        button.hasDefBack = false;
        button.isAnim = true;
        button.txrX = 96;
        button.txrW = 24;
        button.txrH = 24;
        button.setHoverText("animation.hover.frame.add", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(5, x + 116, y - 10, 10, 10, "");
        button.texture = ANIMATION_BUTTONS;
        button.hasDefBack = false;
        button.isAnim = true;
        button.txrX = 72;
        button.txrW = 24;
        button.txrH = 24;
        button.setHoverText("animation.hover.frame.del", new Object[0]);
        button.field_146124_l = this.anim.frames.size() > 1;
        this.addButton(button);
        button = new GuiNpcCheckBox(11, x + 62, y - 2, 74, 12, "gui.smooth", "gui.linearly", this.frame.isSmooth());
        button.setHoverText("animation.hover.smooth." + this.frame.isSmooth(), new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(6, x + 126, y - 10, 10, 10, "");
        button.texture = ANIMATION_BUTTONS;
        button.hasDefBack = false;
        button.isAnim = true;
        button.txrX = 120;
        button.txrW = 24;
        button.txrH = 24;
        button.setHoverText(new TextComponentTranslation("animation.hover.reset.frame", new Object[0]).func_150257_a((ITextComponent)new TextComponentTranslation("animation.hover.shift.0", new Object[0])).func_150254_d(), new Object[0]);
        this.addButton(button);
        this.addLabel(new GuiNpcLabel(lId++, new TextComponentTranslation("gui.time", new Object[0]).func_150254_d() + ":", x, (y += 12) + 2));
        textField = new GuiNpcTextField(1, this, x + 35, y, 48, 12, "" + this.frame.getSpeed());
        textField.setMinMaxDefault(0L, 3600L, this.frame.getSpeed());
        textField.setHoverText("animation.hover.part.ticks", new Object[0]);
        this.addTextField(textField);
        textField = new GuiNpcTextField(2, this, x + 87, y, 48, 12, "" + this.frame.getEndDelay());
        textField.setMinMaxDefault(0L, 3600L, this.frame.getEndDelay());
        textField.setHoverText("animation.hover.part.delay", new Object[0]);
        this.addTextField(textField);
        this.hasExtend = false;
        if (this.anim.type == AnimationKind.DIES || this.anim.type == AnimationKind.JUMP) {
            this.hasExtend = true;
            this.addLabel(new GuiNpcLabel(lId++, new TextComponentTranslation("gui.repeat", new Object[0]).func_150254_d() + ":", x, (y += 14) + 2));
            if (this.anim.repeatLast < 0) {
                this.anim.repeatLast *= -1;
            }
            if (this.anim.repeatLast > this.anim.frames.size()) {
                this.anim.repeatLast = this.anim.frames.size();
            }
            textField = new GuiNpcTextField(0, this, x + 87, y, 48, 12, "" + this.anim.repeatLast);
            textField.setMinMaxDefault(0L, this.anim.frames.size(), this.anim.repeatLast);
            textField.setHoverText("animation.hover.anim.repeat", new Object[0]);
            this.addTextField(textField);
        }
        if (this.anim.type == AnimationKind.ATTACKING) {
            this.hasExtend = true;
            button = new GuiNpcCheckBox(36, x, y += 14, 136, 12, "animation.now.attack", "animation.notyet.attack", this.frame.isNowDamage());
            button.setHoverText("animation.hover.now.attack", new Object[0]);
            this.addButton(button);
        }
        this.addLabel(new GuiNpcLabel(lId++, "animation.hold.right", x + 20, y += 13));
        button = new GuiButtonBiDirectional(37, x + 20, y += 9, 116, 10, new String[]{"animation.stack.type.0", "animation.stack.type.1", "animation.stack.type.3", "animation.stack.type.4", "animation.stack.type.5", "animation.stack.type.6", "animation.stack.type.7", "animation.stack.type.8"}, this.frame.getHoldRightStackType());
        int type = this.frame.getHoldRightStackType();
        if (type == 2) {
            type = 3;
        } else if (type == 3) {
            type = 4;
        }
        button.setHoverText("animation.hover.stack.type." + type, new Object[0]);
        this.addButton(button);
        this.addLabel(new GuiNpcLabel(lId++, "animation.hold.left", x + 20, y += 10));
        button = new GuiButtonBiDirectional(38, x + 20, y += 9, 116, 10, new String[]{"animation.stack.type.0", "animation.stack.type.1", "animation.stack.type.2", "animation.stack.type.4", "animation.stack.type.5", "animation.stack.type.6", "animation.stack.type.7", "animation.stack.type.8"}, this.frame.getHoldLeftStackType());
        type = this.frame.getHoldLeftStackType();
        if (type == 3) {
            type = 4;
        }
        button.setHoverText("animation.hover.stack.type." + type, new Object[0]);
        this.addButton(button);
        this.addLabel(new GuiNpcLabel(lId++, this.isMotion ? "animation.motion" : (this.isHitbox ? "animation.hitbox" : "animation.parts"), x, y += 13));
        button = new GuiNpcButton(29, this.workU + 2, y, 8, 8, "");
        button.texture = ANIMATION_BUTTONS;
        button.hasDefBack = false;
        button.isAnim = true;
        button.txrX = 232;
        button.txrW = 24;
        button.txrH = 24;
        button.field_146124_l = this.partNames == null || !this.partNames.visible;
        button.layerColor = CustomNpcs.colorAnimHoverPart + -16777216;
        button.setHoverText("animation.hover.show.parts", new Object[0]);
        this.addButton(button);
        if (this.anim.type == AnimationKind.ATTACKING) {
            button = new GuiNpcButton(45, this.workU + 2, y + 12, 8, 8, "");
            button.texture = ANIMATION_BUTTONS;
            button.hasDefBack = false;
            button.isAnim = true;
            button.txrX = 232;
            button.txrW = 24;
            button.txrH = 24;
            button.field_146124_l = this.hitboxes == null || !this.hitboxes.visible;
            button.layerColor = -329984;
            button.setHoverText("animation.hover.show.hitboxes", new Object[0]);
            this.addButton(button);
        }
        this.dataParts.clear();
        ArrayList<String> lParts = new ArrayList<String>();
        for (int id : this.frame.parts.keySet()) {
            PartConfig ps = this.frame.parts.get(id);
            String key = new TextComponentTranslation(ps.name, new Object[0]).func_150254_d();
            this.dataParts.put(key, ps);
            lParts.add(key);
        }
        this.scrollParts.setListNotSorted(lParts);
        this.dataHitboxes.clear();
        if (this.scrollHitboxes == null) {
            this.scrollHitboxes = new GuiCustomScroll(this, 1);
            this.scrollHitboxes.setSize(112, 112);
        }
        ArrayList<String> lHitboxes = new ArrayList<String>();
        int i = 0;
        char c = '\u00a7';
        LinkedHashMap<Integer, List<String>> hts = new LinkedHashMap<Integer, List<String>>();
        for (int id : this.frame.damageHitboxes.keySet()) {
            AnimationDamageHitbox aDH = this.frame.damageHitboxes.get(id);
            String key = aDH.getKey();
            this.dataHitboxes.put(key, aDH);
            lHitboxes.add(key);
            ArrayList<String> list = new ArrayList<String>();
            list.add(c + "7ID: " + c + "6" + (id + 1));
            list.add(c + "7D:" + c + "a" + aDH.offset[0]);
            list.add(c + "7H:" + c + "a" + aDH.offset[1]);
            list.add(c + "7W:" + c + "a" + aDH.offset[2]);
            list.add(c + "7Scale X:" + c + "b" + aDH.scale[0]);
            list.add(c + "7Scale Y:" + c + "b" + aDH.scale[1]);
            list.add(c + "7Scale Z:" + c + "b" + aDH.scale[2]);
            hts.put(i, list);
            ++i;
        }
        this.scrollHitboxes.setListNotSorted(lHitboxes);
        this.scrollHitboxes.setHoverTexts(hts);
        if (this.isHitbox && this.toolType == 0) {
            this.toolType = 1;
        }
        button = new GuiNpcButton(7, x + 106, y, 10, 10, "");
        button.texture = ANIMATION_BUTTONS;
        button.hasDefBack = false;
        button.isAnim = true;
        button.txrX = 96;
        button.txrW = 24;
        button.txrH = 24;
        if (this.isHitbox) {
            button.setHoverText("animation.hover.hitbox.add", new Object[0]);
        } else if (this.isMotion) {
            button.setHoverText("animation.hover.not.in.motion", new Object[0]);
        } else {
            button.setHoverText("animation.hover.part.add", new Object[0]);
        }
        this.addButton(button);
        button = new GuiNpcButton(8, x + 116, y, 10, 10, "");
        button.texture = ANIMATION_BUTTONS;
        button.hasDefBack = false;
        button.isAnim = true;
        button.txrX = 72;
        button.txrW = 24;
        button.txrH = 24;
        if (this.isHitbox) {
            button.setHoverText("animation.hover.hitbox.del", new Object[0]);
        } else if (this.isMotion) {
            button.setHoverText("animation.hover.not.in.motion", new Object[0]);
        } else {
            button.setHoverText("animation.hover.part.del", new Object[0]);
        }
        this.addButton(button);
        button = new GuiNpcButton(9, x + 126, y, 10, 10, "");
        button.texture = ANIMATION_BUTTONS;
        button.hasDefBack = false;
        button.isAnim = true;
        button.txrX = 120;
        button.txrW = 24;
        button.txrH = 24;
        button.field_146124_l = !this.isMotion && !this.isHitbox;
        button.setHoverText(new TextComponentTranslation("animation.hover.reset.part", new Object[0]).func_150257_a((ITextComponent)new TextComponentTranslation("animation.hover.shift.0", new Object[0])).func_150254_d(), new Object[0]);
        this.addButton(button);
        button = new GuiNpcCheckBox(10, x, y += 10, 67, 14, "gui.disabled", "gui.enabled", this.part.isDisable());
        button.field_146124_l = !this.isMotion && !this.isHitbox;
        button.setHoverText(new TextComponentTranslation("animation.hover.part.disabled." + !this.part.isDisable(), new Object[0]).func_150257_a((ITextComponent)new TextComponentTranslation("animation.hover.shift.1", new Object[0])).func_150254_d(), new Object[0]);
        this.addButton(button);
        button = new GuiNpcCheckBox(22, x + 69, y, 67, 14, "gui.show", "gui.noshow", this.part.isShow());
        button.field_146124_l = !this.isMotion && !this.isHitbox;
        button.setHoverText(new TextComponentTranslation("animation.hover.part.show." + this.part.isShow(), new Object[0]).func_150257_a((ITextComponent)new TextComponentTranslation("animation.hover.shift.1", new Object[0])).func_150254_d(), new Object[0]);
        this.addButton(button);
        StringBuilder color = new StringBuilder(Integer.toHexString(CustomNpcs.colorAnimHoverPart));
        while (color.length() < 6) {
            color.insert(0, "0");
        }
        button = new GuiNpcButton(12, x, y += 15, 67, 10, color.toString());
        button.texture = ANIMATION_BUTTONS;
        button.hasDefBack = false;
        button.isAnim = true;
        button.txrY = 96;
        button.setTextColor(CustomNpcs.colorAnimHoverPart);
        button.dropShadow = false;
        button.field_146124_l = !this.isMotion && !this.isHitbox;
        button.setHoverText("animation.hover.part.color", new Object[0]);
        this.addButton(button);
        float ch = (float)Math.round(this.anim.chance * 100000.0f) / 1000.0f;
        this.addLabel(new GuiNpcLabel(lId++, new TextComponentTranslation("drop.chance", new Object[0]).func_150254_d() + ":", x, (y += 14) + 1));
        textField = new GuiNpcTextField(10, this, x + 28, y, 40, 12, String.valueOf(ch));
        textField.setMinMaxDoubleDefault(0.0, 100.0, ch);
        textField.setHoverText("animation.hover.chance", new Object[0]);
        this.addTextField(textField);
        this.addLabel(new GuiNpcLabel(lId++, "%", x + 72, y + 1));
        this.addLabel(new GuiNpcLabel(lId++, new TextComponentTranslation("advanced.sounds", new Object[0]).func_150254_d() + ":", x, y += 16));
        textField = new GuiNpcTextField(3, this, x, y + 10, 135, 12, this.frame.getStartSound());
        textField.setHoverText("animation.hover.sound", new Object[0]);
        this.addTextField(textField);
        button = new GuiNpcButton(27, x + textField.field_146218_h - 17, y, 8, 8, "S");
        button.texture = ANIMATION_BUTTONS;
        button.hasDefBack = false;
        button.isAnim = true;
        button.txrY = 96;
        button.dropShadow = false;
        button.setTextColor(-2359296);
        button.setHoverText("animation.hover.select.sound", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(28, x + textField.field_146218_h - 8, y, 8, 8, "X");
        button.texture = ANIMATION_BUTTONS;
        button.hasDefBack = false;
        button.isAnim = true;
        button.txrY = 96;
        button.dropShadow = false;
        button.setTextColor(-2359296);
        button.setHoverText("animation.hover.del.sound", new Object[0]);
        this.addButton(button);
        this.addLabel(new GuiNpcLabel(lId++, new TextComponentTranslation("advanced.emotion", new Object[0]).func_150254_d() + ":", x, y += 26));
        textField = new GuiNpcTextField(4, this, x, y + 10, 48, 12, "" + this.frame.getStartEmotion());
        textField.setMinMaxDefault(0L, AnimationController.getInstance().getUnusedEmtnId() - 1, this.frame.getStartEmotion());
        textField.setHoverText("animation.hover.emotion.id", new Object[0]);
        this.addTextField(textField);
        this.addLabel(new GuiNpcLabel(lId, "animation.show.stacks", x, y += 26));
        button = new GuiNpcButton(39, x + 2, y += 10, 12, 12, "");
        button.texture = ANIMATION_BUTTONS_SLOTS;
        button.hasDefBack = false;
        button.txrY = this.frame.showMainHand ? 0 : 96;
        button.txrW = 24;
        button.txrH = 24;
        button.setHoverText("animation.hover.0", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(40, x + 16, y, 12, 12, "");
        button.texture = ANIMATION_BUTTONS_SLOTS;
        button.hasDefBack = false;
        button.txrX = 24;
        button.txrY = this.frame.showOffHand ? 0 : 96;
        button.txrW = 24;
        button.txrH = 24;
        button.setHoverText("animation.hover.1", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(41, x + 30, y, 12, 12, "");
        button.texture = ANIMATION_BUTTONS_SLOTS;
        button.hasDefBack = false;
        button.txrX = 48;
        button.txrY = this.frame.showHelmet ? 0 : 96;
        button.txrW = 24;
        button.txrH = 24;
        button.setHoverText("animation.hover.2", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(42, x + 44, y, 12, 12, "");
        button.texture = ANIMATION_BUTTONS_SLOTS;
        button.hasDefBack = false;
        button.txrX = 72;
        button.txrY = this.frame.showBody ? 0 : 96;
        button.txrW = 24;
        button.txrH = 24;
        button.setHoverText("animation.hover.3", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(43, x + 58, y, 12, 12, "");
        button.texture = ANIMATION_BUTTONS_SLOTS;
        button.hasDefBack = false;
        button.txrX = 96;
        button.txrY = this.frame.showLegs ? 0 : 96;
        button.txrW = 24;
        button.txrH = 24;
        button.setHoverText("animation.hover.4", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(44, x + 72, y, 12, 12, "");
        button.texture = ANIMATION_BUTTONS_SLOTS;
        button.hasDefBack = false;
        button.txrX = 120;
        button.txrY = this.frame.showFeets ? 0 : 96;
        button.txrW = 24;
        button.txrH = 24;
        button.setHoverText("animation.hover.5", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(66, x, this.winV + this.winH - 12, 50, 10, "gui.back");
        button.texture = ANIMATION_BUTTONS;
        button.hasDefBack = false;
        button.isAnim = true;
        button.txrY = 96;
        button.setHoverText("hover.back", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(13, this.workU + 25, this.workV + 2, 8, 8, "");
        button.layerColor = meshType == 0 ? -2543504 : -13235172;
        button.texture = ANIMATION_BUTTONS;
        button.hasDefBack = false;
        button.isAnim = true;
        button.txrY = 96;
        button.setHoverText(new TextComponentTranslation("animation.hover.mesh.0", new Object[0]).func_150257_a((ITextComponent)new TextComponentTranslation("animation.hover.again", new Object[0])).func_150254_d(), new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(14, this.workU + 34, this.workV + 2, 8, 8, "");
        button.layerColor = meshType == 1 ? -9948967 : -15070154;
        button.texture = ANIMATION_BUTTONS;
        button.hasDefBack = false;
        button.isAnim = true;
        button.txrY = 96;
        button.setHoverText(new TextComponentTranslation("animation.hover.mesh.1", new Object[0]).func_150257_a((ITextComponent)new TextComponentTranslation("animation.hover.again", new Object[0])).func_150254_d(), new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(15, this.workU + 43, this.workV + 2, 8, 8, "");
        button.layerColor = meshType == 2 ? -13575808 : -15976928;
        button.texture = ANIMATION_BUTTONS;
        button.hasDefBack = false;
        button.isAnim = true;
        button.txrY = 96;
        button.setHoverText(new TextComponentTranslation("animation.hover.mesh.2", new Object[0]).func_150257_a((ITextComponent)new TextComponentTranslation("animation.hover.again", new Object[0])).func_150254_d(), new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(16, this.workU + 52, this.workV + 2, 8, 8, "");
        button.layerColor = meshType == 3 ? -2631376 : -13289972;
        button.texture = ANIMATION_BUTTONS;
        button.hasDefBack = false;
        button.isAnim = true;
        button.txrY = 96;
        button.setHoverText(new TextComponentTranslation("animation.hover.mesh.3", new Object[0]).func_150257_a((ITextComponent)new TextComponentTranslation("animation.hover.again", new Object[0])).func_150254_d(), new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(17, this.workU + 61, this.workV + 2, 8, 8, "");
        button.layerColor = showHitBox ? 0 : -8355712;
        button.texture = ANIMATION_BUTTONS;
        button.hasDefBack = false;
        button.isAnim = true;
        button.txrY = 96;
        button.setHoverText(new TextComponentTranslation("animation.hover.hitbox", new Object[0]).func_150257_a((ITextComponent)new TextComponentTranslation("animation.hover.again", new Object[0])).func_150254_d(), new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(49, this.workU + 79, this.workV + 2, 8, 8, "x");
        button.layerColor = -8038982;
        button.texture = ANIMATION_BUTTONS;
        button.hasDefBack = false;
        button.isAnim = true;
        button.txrY = 96;
        button.setHoverText("animation.hover.align.xy", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(50, this.workU + 79, this.workV + 11, 8, 8, "z");
        button.layerColor = -8038982;
        button.texture = ANIMATION_BUTTONS;
        button.hasDefBack = false;
        button.isAnim = true;
        button.txrY = 96;
        button.setHoverText("animation.hover.align.zy", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(51, this.workU + 88, this.workV + 2, 8, 8, "y");
        button.layerColor = -8038982;
        button.texture = ANIMATION_BUTTONS;
        button.hasDefBack = false;
        button.isAnim = true;
        button.txrY = 96;
        button.setHoverText("animation.hover.align.xz", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(52, this.workU + 97, this.workV + 11, 8, 8, "r");
        button.layerColor = -11174470;
        button.texture = ANIMATION_BUTTONS;
        button.hasDefBack = false;
        button.isAnim = true;
        button.txrY = 96;
        button.setHoverText("animation.hover.align.revers", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(18, this.workU + this.workS - 10, this.workV + 2, 8, 8, "");
        button.texture = ANIMATION_BUTTONS;
        button.hasDefBack = false;
        button.isAnim = true;
        button.txrY = 96;
        button.setHoverText("animation.hover.reset.scale", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(19, this.workU + 2, this.workV + this.workS - 10, 8, 8, "");
        button.texture = ANIMATION_BUTTONS;
        button.hasDefBack = false;
        button.isAnim = true;
        button.txrY = 96;
        button.setHoverText("animation.hover.reset.pos", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(20, this.workU + this.workS - 10, this.workV + this.workS - 10, 8, 8, "");
        button.texture = ANIMATION_BUTTONS;
        button.hasDefBack = false;
        button.isAnim = true;
        button.txrY = 96;
        button.setHoverText("animation.hover.reset.rot", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(21, this.workU + this.workS / 2 - 11, this.workV + this.workS - 12, 18, 10, "");
        button.texture = ANIMATION_BUTTONS;
        button.hasDefBack = false;
        button.isAnim = true;
        button.txrX = this.onlyCurrentPart ? 144 : 188;
        button.txrW = 44;
        button.txrH = 24;
        button.setHoverText(new TextComponentTranslation("animation.hover.work." + this.onlyCurrentPart, new Object[]{"\u00a76" + (this.frame != null ? this.frame.id + 1 : -1)}).func_150254_d(), new Object[0]);
        this.addButton(button);
        y = this.workV + this.workS - 74;
        this.addLabel(new GuiNpcLabel(50, "0", this.workU + this.workS / 2 + 10, this.workV + this.workS - 12, GuiNpcAnimation.backColor == -16777216 ? -1 : -16777216));
        this.addLabel(new GuiNpcLabel(51, "0", this.workU + this.workS / 2 - 13, this.workV + this.workS - 12, GuiNpcAnimation.backColor == -16777216 ? -1 : -16777216));
        button = new GuiButtonBiDirectional(53, this.workU + this.workS / 2 - 56, this.workV + this.workS - 24, 108, 10, new String[]{""}, 0);
        button.setHoverText("animation.hover.part.all.ticks", new Object[0]);
        button.setIsVisible(this.onlyCurrentPart);
        this.addButton(button);
        button = new GuiNpcButton(35, this.workU + 5, y, 8, 8, "");
        button.texture = ANIMATION_BUTTONS;
        button.hasDefBack = false;
        button.isAnim = true;
        button.txrX = 232;
        button.txrW = 24;
        button.txrH = 24;
        button.field_146124_l = this.tools == null || !this.tools.visible;
        button.setHoverText("animation.hover.show.tools", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(23, this.workU + 2, y += 10, 14, 14, "");
        button.texture = ANIMATION_BUTTONS;
        button.hasDefBack = false;
        button.isAnim = true;
        button.txrW = 24;
        button.txrH = 24;
        button.layerColor = this.toolType == 1 ? new Color(-49088).getRGB() : new Color(-1).getRGB();
        button.setHoverText("animation.hover.tool.0", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(24, this.workU + 2, y += 16, 14, 14, "");
        button.texture = ANIMATION_BUTTONS;
        button.hasDefBack = false;
        button.isAnim = true;
        button.txrX = 24;
        button.txrW = 24;
        button.txrH = 24;
        button.layerColor = this.toolType == 0 ? new Color(-12517568).getRGB() : new Color(-1).getRGB();
        button.field_146124_l = !this.isHitbox && !this.isMotion;
        button.setHoverText("animation.hover.tool.1", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(25, this.workU + 2, y + 16, 14, 14, "");
        button.texture = ANIMATION_BUTTONS;
        button.hasDefBack = false;
        button.isAnim = true;
        button.txrX = 48;
        button.txrW = 24;
        button.txrH = 24;
        button.layerColor = this.toolType == 2 ? new Color(-12566273).getRGB() : new Color(-1).getRGB();
        button.field_146124_l = !this.isMotion;
        button.setHoverText("animation.hover.tool.2", new Object[0]);
        this.addButton(button);
        this.resetAnimation();
        boolean vPN = this.partNames == null || this.partNames.visible;
        this.showPartNames();
        this.partNames.visible = vPN;
        this.partNames.objs = new Object[]{this.part, this.toolType};
        boolean vT = this.tools == null || this.tools.visible;
        this.showTools();
        this.tools.visible = vT;
        if (this.anim.type == AnimationKind.ATTACKING) {
            boolean vH = this.hitboxes == null || this.hitboxes.visible;
            this.showHitBoxes();
            this.hitboxes.visible = vH;
        }
        if (ModelNpcAlt.editAnimDataSelect.part != (this.part == null ? -1 : this.part.id)) {
            this.setPart(this.part);
        }
    }

    private void showHitBoxes() {
        if (this.hitboxes == null) {
            this.hitboxes = new GuiNpcMiniWindow(this, 2, this.workU + 18, this.workV + 12, 120, 118, new TextComponentTranslation("gui.hitboxes", new Object[]{":"}).func_150254_d());
            this.hitboxes.widthTexture = 256;
            this.hitboxes.heightTexture = 256;
            this.hitboxes.setColorLine(16447232);
            this.hitboxes.addScroll(this.scrollHitboxes);
        }
        this.hitboxes.setPoint(this.getButton(45));
        this.scrollHitboxes.guiLeft = this.hitboxes.guiLeft + 4;
        this.scrollHitboxes.guiTop = this.hitboxes.guiTop + 12;
        this.addMiniWindow(this.hitboxes);
    }

    private void showTools() {
        GuiNpcButton button;
        GuiNpcTextField textField;
        boolean notNormal;
        int f = 11;
        int h = 0;
        int x = this.workU + 18;
        int y = this.workV + this.workS - 65;
        boolean bl = notNormal = this.toolType == 0 && this.part != null && (this.addedPartConfig != null && !this.addedPartConfig.isNormal || this.part.id >= 1 && this.part.id <= 5);
        if (this.isHitbox) {
            notNormal = false;
        }
        y += notNormal ? -11 : 0;
        if (this.tools != null) {
            x = this.tools.guiLeft;
            y = this.tools.guiTop;
            h = this.tools.ySize;
        }
        this.tools = new GuiNpcMiniWindow(this, 1, x, y, 146, notNormal ? 60 : 38, new TextComponentTranslation("gui.tools", new Object[0]).func_150254_d() + ":");
        this.tools.widthTexture = 256;
        this.tools.heightTexture = 256;
        x += 4;
        y += 13;
        for (int i = 0; i < 3; ++i) {
            float[] values;
            this.tools.addLabel(new GuiNpcLabel(i, i == 0 ? (this.toolType == 1 && this.isHitbox || this.isMotion ? "D:" : "X:") : (i == 1 ? (this.toolType == 1 && this.isHitbox || this.isMotion ? "H:" : "Y:") : (this.toolType == 1 && this.isHitbox || this.isMotion ? "W:" : "Z:")), x, y + i * f));
            if (this.isHitbox && this.hitbox != null) {
                values = this.toolType == 1 ? this.hitbox.offset : this.hitbox.scale;
            } else if (this.isMotion && this.frame != null) {
                this.toolType = 1;
                values = this.frame.motions;
            } else {
                values = this.toolType == 0 ? this.part.rotation : (this.toolType == 1 ? this.part.offset : this.part.scale);
            }
            float[] textToFields = new float[values.length];
            float[] sliderValues = new float[values.length];
            switch (this.toolType) {
                case 1: {
                    if (i == 2 && (this.isHitbox || this.isMotion)) {
                        textToFields[i] = (float)Math.round((double)(values[i] * 180000.0f) / Math.PI) / 1000.0f;
                        sliderValues[i] = ValueUtil.correctFloat(values[i] * 0.159155f + 0.5f, 0.0f, 1.0f);
                        break;
                    }
                    textToFields[i] = (float)Math.round(values[i] * 1000.0f) / 1000.0f;
                    if (this.isMotion) {
                        if (i == 0) {
                            sliderValues[i] = ValueUtil.correctFloat(values[i] * 2.0f / 3.0f, 0.0f, 1.0f);
                            break;
                        }
                        sliderValues[i] = ValueUtil.correctFloat(values[i] / 3.0f + 0.5f, 0.0f, 1.0f);
                        break;
                    }
                    if (this.isHitbox) {
                        if (i == 0) {
                            sliderValues[i] = ValueUtil.correctFloat(values[i] * 0.1f, 0.0f, 1.0f);
                            break;
                        }
                        sliderValues[i] = ValueUtil.correctFloat(values[i] * 0.05f + 0.5f, 0.0f, 1.0f);
                        break;
                    }
                    sliderValues[i] = ValueUtil.correctFloat(values[i] * 0.1f + 0.5f, 0.0f, 1.0f);
                    break;
                }
                case 2: {
                    textToFields[i] = (float)Math.round(values[i] * 1000.0f) / 1000.0f;
                    sliderValues[i] = ValueUtil.correctFloat(values[i] * 0.2f, 0.0f, 1.0f);
                    break;
                }
                default: {
                    textToFields[i] = (float)Math.round((double)(values[i] * 180000.0f) / Math.PI) / 1000.0f;
                    sliderValues[i] = ValueUtil.correctFloat(values[i] * 0.159155f + 0.5f, 0.0f, 1.0f);
                }
            }
            GuiNpcSlider slider = new GuiNpcSlider(this.tools, i, x + 9, y + i * f, 75, 8, sliderValues[i]);
            slider.setHoverText("animation.hover." + (this.toolType == 0 ? "rotation" : (this.toolType == 1 ? "offset" : "scale")), i == 0 ? "X" : (i == 1 ? "Y" : "Z"));
            this.tools.addSlider(slider);
            textField = new GuiNpcTextField(i + 5, this.tools, x + 86, y + i * f, 42, 8, "" + textToFields[i]);
            double m = -180.0;
            double n = 180.0;
            if (this.toolType == 1) {
                if (this.isMotion) {
                    if (i == 0) {
                        m = 0.0;
                        n = 1.5;
                    }
                    if (i == 1) {
                        m = -1.5;
                        n = 1.5;
                    }
                } else if (this.isHitbox) {
                    if (i == 0) {
                        m = 0.0;
                        n = 10.0;
                    }
                    if (i == 1) {
                        m = -10.0;
                        n = 10.0;
                    }
                } else {
                    m = -5.0;
                    n = 5.0;
                }
            } else if (this.toolType == 2) {
                m = 0.0;
                n = 5.0;
            }
            textField.setMinMaxDoubleDefault(m, n, textToFields[i]);
            textField.setHoverText("animation.hover." + (this.toolType == 0 ? "rotation" : (this.toolType == 1 ? "offset" : "scale")), i == 0 ? "X" : (i == 1 ? "Y" : "Z"));
            this.tools.addTextField(textField);
            button = new GuiNpcButton(30 + i, x + 130, y + i * f, 8, 8, "X");
            button.texture = ANIMATION_BUTTONS;
            button.hasDefBack = false;
            button.isAnim = true;
            button.txrY = 96;
            button.dropShadow = false;
            button.setTextColor(-2359296);
            button.setHoverText("animation.hover.reset." + this.toolType, i == 0 ? "X" : (i == 1 ? "Y" : "Z"));
            this.tools.addButton(button);
        }
        if (!this.isHitbox && notNormal) {
            this.tools.addLabel(new GuiNpcLabel(3, "X1:", x, y += 33));
            float sliderValue = this.part.rotation[3] * 0.159155f + 0.5f;
            float textToFields = (float)Math.round((double)(this.part.rotation[3] * 180000.0f) / Math.PI) / 1000.0f;
            GuiNpcSlider slider = new GuiNpcSlider(this.tools, 3, x + 9, y, 75, 8, sliderValue);
            slider.setHoverText("animation.hover.rotation", "X 1");
            this.tools.addSlider(slider);
            textField = new GuiNpcTextField(8, this.tools, x + 86, y, 42, 8, "" + textToFields);
            textField.setMinMaxDoubleDefault(-180.0, 180.0, textToFields);
            textField.setHoverText("animation.hover.rotation", "X 1");
            this.tools.addTextField(textField);
            button = new GuiNpcButton(33, x + 130, y, 8, 8, "X");
            button.texture = ANIMATION_BUTTONS;
            button.hasDefBack = false;
            button.isAnim = true;
            button.txrY = 96;
            button.dropShadow = false;
            button.setTextColor(-2359296);
            button.setHoverText("animation.hover.reset.0", "X 1");
            this.tools.addButton(button);
            this.tools.addLabel(new GuiNpcLabel(4, "Y1:", x, y += 11));
            sliderValue = this.part.rotation[4] * 0.31831f + 0.5f;
            textToFields = (float)Math.round((double)(this.part.rotation[4] * 180000.0f) / Math.PI) / 1000.0f;
            slider = new GuiNpcSlider(this.tools, 4, x + 9, y, 75, 8, sliderValue);
            slider.setHoverText("animation.hover.rotation", "Y 1");
            this.tools.addSlider(slider);
            textField = new GuiNpcTextField(9, this.tools, x + 86, y, 42, 8, "" + textToFields);
            textField.setMinMaxDoubleDefault(-90.0, 90.0, textToFields);
            textField.setHoverText("animation.hover.rotation", "Y 1");
            this.tools.addTextField(textField);
            button = new GuiNpcButton(34, x + 130, y, 8, 8, "X");
            button.texture = ANIMATION_BUTTONS;
            button.hasDefBack = false;
            button.isAnim = true;
            button.txrY = 96;
            button.dropShadow = false;
            button.setTextColor(-2359296);
            button.setHoverText("animation.hover.reset.0", "Y 1");
            this.tools.addButton(button);
            if (h != 72) {
                this.tools.moveOffset(0, -11);
            }
        } else if (h != 50) {
            this.tools.moveOffset(0, 11);
        }
        switch (this.toolType) {
            case 1: {
                this.tools.setPoint(this.getButton(23));
                this.tools.setColorLine(0xFF8080);
                break;
            }
            case 2: {
                this.tools.setPoint(this.getButton(25));
                this.tools.setColorLine(0x8080FF);
                break;
            }
            default: {
                this.tools.setPoint(this.getButton(24));
                this.tools.setColorLine(0x80FF80);
            }
        }
        if (this.getButton(35) != null) {
            this.getButton(35).setLayerColor(this.tools.getColorLine() + -16777216);
        }
        this.addMiniWindow(this.tools);
    }

    private void showPartNames() {
        if (this.partNames == null) {
            this.partNames = new GuiNpcMiniWindow(this, 0, this.workU + this.workS - 78, this.workV + 12, 75, 129, new TextComponentTranslation("gui.parts", new Object[0]).func_150254_d() + ":");
            this.partNames.widthTexture = 256;
            this.partNames.heightTexture = 256;
            this.partNames.setColorLine(CustomNpcs.colorAnimHoverPart);
            this.scrollParts.setSelect(this.part.id);
            this.partNames.addScroll(this.scrollParts);
            this.partNames.addButton(new GuiNpcButton(48, this.partNames.guiLeft + 4, this.partNames.guiTop + 125, 67, 12, "ai.movement"));
        }
        this.partNames.setPoint(this.getButton(29));
        if (this.scrollParts != null) {
            this.scrollParts.guiLeft = this.partNames.guiLeft + 4;
            this.scrollParts.guiTop = this.partNames.guiTop + 12;
        }
        if (this.partNames.getButton(48) != null) {
            this.partNames.getButton(48).setLeft(this.partNames.guiLeft + 4);
            this.partNames.getButton(48).setTop(this.partNames.guiTop + 125);
        }
        this.addMiniWindow(this.partNames);
    }

    private boolean isPressAndKey(int type, int id) {
        boolean isPress;
        if (this.waitKey > 0 && this.waitKeyID == id) {
            return false;
        }
        boolean bl = type == 0 ? SubGuiEditAnimation.func_175283_s() : (type == 1 ? SubGuiEditAnimation.func_146271_m() : (isPress = SubGuiEditAnimation.func_146272_n() && Keyboard.isKeyDown((int)id)));
        if (isPress) {
            this.waitKey = 30;
            this.waitKeyID = id;
        }
        return isPress;
    }

    @Override
    public void func_73869_a(char c, int i) {
        if (this.subgui == null) {
            if (i == 1) {
                this.close();
                return;
            }
            if (this.isPressAndKey(0, 16) && this.toolType != 1) {
                this.toolType = 1;
                this.playButtonClick();
                this.func_73866_w_();
            }
            if (this.isPressAndKey(0, 17) && this.toolType != 0) {
                this.toolType = 0;
                this.playButtonClick();
                this.func_73866_w_();
            }
            if (this.isPressAndKey(0, 18) && this.toolType != 2) {
                this.toolType = 2;
                this.playButtonClick();
                this.func_73866_w_();
            }
            if (this.isPressAndKey(0, 25)) {
                boolean bl = this.onlyCurrentPart = !this.onlyCurrentPart;
                if (this.getButton(21) != null) {
                    this.getButton(21).setTextureXY(this.onlyCurrentPart ? 144 : 188, this.getButton(21).getTextureXY()[1]);
                }
                this.playButtonClick();
                this.isChanged = true;
                this.func_73866_w_();
            }
            if (this.isPressAndKey(0, 31)) {
                this.dispScale = 1.0f;
                this.playButtonClick();
            }
            if (this.isPressAndKey(0, 19)) {
                this.dispRot[0] = 45.0f;
                this.dispRot[1] = 345.0f;
                this.dispRot[2] = 345.0f;
                this.playButtonClick();
            }
            if (this.isPressAndKey(0, 24)) {
                for (int j = 0; j < 3; ++j) {
                    this.dispPos[j] = 0.0f;
                }
                this.playButtonClick();
            }
            if (this.isPressAndKey(2, 45)) {
                this.dispRot[0] = 0.0f;
                this.dispRot[1] = 0.0f;
                this.dispRot[2] = 0.0f;
                this.playButtonClick();
            }
            if (this.isPressAndKey(2, 21)) {
                this.dispRot[0] = 0.0f;
                this.dispRot[1] = 270.0f;
                this.dispRot[2] = 0.0f;
                this.playButtonClick();
            }
            if (this.isPressAndKey(2, 44)) {
                this.dispRot[0] = 90.0f;
                this.dispRot[1] = 0.0f;
                this.dispRot[2] = 0.0f;
                this.playButtonClick();
            }
            if (this.isPressAndKey(2, 19)) {
                this.displayRotate(180, 0);
                this.playButtonClick();
            }
        }
        super.func_73869_a(c, i);
    }

    @Override
    public void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        if (this.subgui != null) {
            this.subgui.func_73864_a(mouseX, mouseY, mouseButton);
            return;
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (this.hoverMiniWin) {
            return;
        }
        if (this.hoverRight && this.frame.getHoldRightStackType() == 3) {
            IItemStack stack;
            switch (this.frame.getHoldRightStackType()) {
                case 1: {
                    stack = this.npc.inventory.getProjectile();
                    break;
                }
                case 2: {
                    stack = this.npc.inventory.getLeftHand();
                    break;
                }
                case 3: {
                    stack = this.frame.getHoldRightStack();
                    break;
                }
                default: {
                    stack = this.npc.inventory.getRightHand();
                }
            }
            this.setSubGui(new SubGuiSelectItemStack(0, stack == null || stack.isEmpty() ? ItemStack.field_190927_a : stack.getMCItemStack()));
        } else if (this.hoverLeft && this.frame.getHoldLeftStackType() == 3) {
            IItemStack stack;
            switch (this.frame.getHoldLeftStackType()) {
                case 1: {
                    stack = this.npc.inventory.getProjectile();
                    break;
                }
                case 2: {
                    stack = this.npc.inventory.getRightHand();
                    break;
                }
                case 3: {
                    stack = this.frame.getHoldLeftStack();
                    break;
                }
                default: {
                    stack = this.npc.inventory.getLeftHand();
                }
            }
            this.setSubGui(new SubGuiSelectItemStack(1, stack == null || stack.isEmpty() ? ItemStack.field_190927_a : stack.getMCItemStack()));
        } else if ((mouseButton == 0 || mouseButton == 1) && this.hovered) {
            this.mousePressId = mouseButton;
            this.mousePressX = mouseX;
            this.mousePressY = mouseY;
        }
    }

    @Override
    public void mouseDragged(IGuiNpcSlider slider) {
        this.isChanged = true;
        float value = 0.0f;
        float pi = (float)Math.PI;
        if (this.isHitbox) {
            if (this.hitbox == null || this.toolType == 0) {
                return;
            }
            if (this.toolType == 1) {
                if (slider.getID() == 0) {
                    this.hitbox.offset[0] = 10.0f * slider.getSliderValue();
                    value = (float)Math.round(this.hitbox.offset[0] * 1000.0f) / 1000.0f;
                } else if (slider.getID() == 1) {
                    this.hitbox.offset[1] = 20.0f * slider.getSliderValue() - 10.0f;
                    value = (float)Math.round(this.hitbox.offset[1] * 1000.0f) / 1000.0f;
                } else if (slider.getID() == 2) {
                    this.hitbox.offset[2] = 2.0f * pi * slider.getSliderValue() - pi;
                    value = Math.round(360.0f * slider.getSliderValue() - 180.0f);
                }
            } else {
                this.hitbox.scale[slider.getID()] = value = (float)Math.round(5000.0f * slider.getSliderValue()) / 1000.0f;
            }
            if (this.tools.getTextField(5 + slider.getID()) != null) {
                this.tools.getTextField(5 + slider.getID()).setFullText("" + value);
            }
            return;
        }
        if (this.isMotion) {
            if (this.toolType != 1) {
                return;
            }
            if (slider.getID() == 0) {
                this.frame.motions[0] = value = (float)Math.round(slider.getSliderValue() * 1500.0f) / 1000.0f;
            } else if (slider.getID() == 1) {
                this.frame.motions[1] = value = (float)Math.round((slider.getSliderValue() * 3.0f - 1.5f) * 1000.0f) / 1000.0f;
            } else if (slider.getID() == 2) {
                value = Math.round(360.0f * slider.getSliderValue() - 180.0f);
                this.frame.motions[2] = 2.0f * pi * slider.getSliderValue() - pi;
            }
            if (this.tools.getTextField(5 + slider.getID()) != null) {
                this.tools.getTextField(5 + slider.getID()).setFullText("" + value);
            }
            return;
        }
        if (this.part == null) {
            return;
        }
        if (slider.getID() == 3 || slider.getID() == 4) {
            if (this.toolType != 0) {
                return;
            }
            this.part.rotation[slider.getID()] = (2.0f * pi * slider.getSliderValue() - pi) / (slider.getID() == 4 ? 2.0f : 1.0f);
            value = (float)Math.round(360.0f * slider.getSliderValue() - 180.0f) / (slider.getID() == 4 ? 2.0f : 1.0f);
        } else {
            switch (this.toolType) {
                case 0: {
                    this.part.rotation[slider.getID()] = 2.0f * pi * slider.getSliderValue() - pi;
                    value = Math.round(360.0f * slider.getSliderValue() - 180.0f);
                    break;
                }
                case 1: {
                    this.part.offset[slider.getID()] = slider.getSliderValue() * 10.0f - 5.0f;
                    value = (float)Math.round(this.part.offset[slider.getID()] * 1000.0f) / 1000.0f;
                    break;
                }
                case 2: {
                    this.part.scale[slider.getID()] = slider.getSliderValue() * 5.0f;
                    value = (float)Math.round(this.part.scale[slider.getID()] * 1000.0f) / 1000.0f;
                }
            }
        }
        if (this.tools.getTextField(5 + slider.getID()) != null) {
            this.tools.getTextField(5 + slider.getID()).setFullText("" + value);
        }
        this.resetAnimation();
    }

    @Override
    public void mousePressed(IGuiNpcSlider slider) {
    }

    @Override
    public void mouseReleased(IGuiNpcSlider slider) {
    }

    private void playButtonClick() {
        this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
    }

    private void postRender() {
        GlStateManager.func_179109_b((float)((float)this.workU + (float)this.workS / 2.0f), (float)((float)this.workV + (float)this.workS / 2.0f), (float)(100.0f * this.dispScale));
        GlStateManager.func_179109_b((float)this.dispPos[0], (float)this.dispPos[1], (float)0.0f);
        GlStateManager.func_179114_b((float)this.dispRot[0], (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)this.dispRot[1], (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)this.dispRot[2], (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179152_a((float)this.dispScale, (float)this.dispScale, (float)this.dispScale);
        GlStateManager.func_179109_b((float)0.0f, (float)25.0f, (float)0.0f);
    }

    private void resetAnimation() {
        if (!this.isChanged || this.anim == null || this.frame == null || this.npcAnim == null) {
            return;
        }
        this.npcAnim.field_70165_t = this.basePos[0];
        this.npcAnim.field_70163_u = this.basePos[1];
        this.npcAnim.field_70161_v = this.basePos[2];
        this.npcPart.field_70165_t = this.basePos[0];
        this.npcPart.field_70163_u = this.basePos[1];
        this.npcPart.field_70161_v = this.basePos[2];
        this.npcAnim.animation.reset();
        this.npcAnim.animation.tryRunAnimation(this.anim, AnimationKind.EDITING_All);
        this.npcAnim.func_70606_j(this.npcAnim.func_110138_aP());
        this.npcAnim.field_70725_aQ = 0;
        this.npcPart.animation.reset();
        this.npcPart.animation.tryRunAnimation(this.anim, AnimationKind.EDITING_PART);
        this.npcPart.func_70606_j(this.npcPart.func_110138_aP());
        this.npcPart.field_70725_aQ = 0;
        if (this.getButton(53) != null) {
            GuiNpcButton button = (GuiNpcButton)this.getButton(53);
            button.setIsVisible(this.onlyCurrentPart);
            if (this.onlyCurrentPart) {
                ArrayList<String> ticks = new ArrayList<String>();
                int s = this.npcPart.animation.getAnimationSpeedTicks();
                for (int i = 0; i <= s; ++i) {
                    ticks.add(i + "/" + s);
                }
                button.resetDisplay(ticks);
            }
        }
    }

    @Override
    public void scrollClicked(int mouseX, int mouseY, int mouseButton, IGuiCustomScroll scroll) {
        GuiNpcTextField.unfocus();
        if (this.isMotion) {
            this.isMotion = false;
            this.partNames.getButton(48).setEnabled(true);
        }
        if (scroll.getID() == 0) {
            if (this.anim.type == AnimationKind.ATTACKING) {
                this.setHitbox(null);
            }
            if (this.part.id == this.dataParts.get((Object)scroll.getSelected()).id) {
                return;
            }
            this.setPart(this.dataParts.get(scroll.getSelected()));
            this.func_73866_w_();
        } else if (scroll.getID() == 1 && this.anim.type == AnimationKind.ATTACKING) {
            this.setHitbox(this.dataHitboxes.get(scroll.getSelected()));
            if (this.scrollParts != null) {
                this.scrollParts.setSelect(-1);
            }
            this.func_73866_w_();
        }
        this.func_73866_w_();
    }

    @Override
    public void scrollDoubleClicked(String selection, IGuiCustomScroll scroll) {
    }

    private void setEnvironment() {
        this.environmentEntitys.clear();
        this.environmentStates.clear();
        this.environmentTiles.clear();
        if (this.npc == null || this.npc.field_70170_p == null) {
            return;
        }
        this.offsetY = 0.0f;
        if (this.npc.field_70163_u != Math.floor(this.npc.field_70163_u)) {
            this.offsetY = (float)((this.npc.field_70163_u - (double)Math.round(this.npc.field_70163_u)) * 16.0);
        }
        for (int y = -4; y <= 4; ++y) {
            for (int x = -4; x <= 4; ++x) {
                for (int z = -4; z <= 4; ++z) {
                    double yP = this.npc.field_70163_u + (double)y - 1.0;
                    if (this.npc.field_70163_u != Math.floor(this.npc.field_70163_u)) {
                        yP = Math.ceil(this.npc.field_70163_u) + (double)y - 1.0;
                    }
                    BlockPos posWorld = new BlockPos(this.npc.field_70165_t + (double)x, yP, this.npc.field_70161_v + (double)z);
                    IBlockState state = this.npc.field_70170_p.func_180495_p(posWorld);
                    TileEntity tile = this.npc.field_70170_p.func_175625_s(posWorld);
                    if (tile != null && TileEntityRendererDispatcher.field_147556_a.field_147559_m.get(tile.getClass()) == null) {
                        tile = null;
                    }
                    BlockPos pos = new BlockPos(x, y, z);
                    this.environmentStates.put(pos, state);
                    this.environmentTiles.put(pos, tile);
                }
            }
        }
        List entities = new ArrayList();
        try {
            entities = this.npc.field_70170_p.func_72872_a(Entity.class, new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).func_186670_a(this.npc.func_180425_c()).func_72314_b(4.55, 4.55, 4.55));
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (Entity e : entities) {
            EntityNPCInterface le;
            if (e.equals((Object)this.npc)) continue;
            NBTTagCompound nbt = new NBTTagCompound();
            if (e instanceof EntityNPCInterface) {
                le = Util.instance.copyToGUI((EntityNPCInterface)e, (World)this.field_146297_k.field_71441_e, true);
            } else {
                e.func_184198_c(nbt);
                le = EntityList.func_75615_a((NBTTagCompound)nbt, (World)this.npc.field_70170_p);
            }
            if (le == null) continue;
            ((Entity)le).field_70165_t -= this.npc.field_70165_t;
            ((Entity)le).field_70163_u -= this.npc.field_70163_u;
            ((Entity)le).field_70161_v -= this.npc.field_70161_v;
            ((Entity)le).field_70177_z = e.field_70177_z;
            ((Entity)le).field_70126_B = e.field_70177_z;
            ((Entity)le).field_70125_A = e.field_70125_A;
            ((Entity)le).field_70127_C = e.field_70125_A;
            this.environmentEntitys.add((Entity)le);
        }
    }

    @Override
    public void subGuiClosed(SubGuiInterface subgui) {
        if (subgui.getId() == 0 && subgui instanceof SubGuiColorSelector) {
            CustomNpcs.colorAnimHoverPart = ((SubGuiColorSelector)subgui).color;
            ModelNpcAlt.editAnimDataSelect.red = (float)(CustomNpcs.colorAnimHoverPart >> 16 & 0xFF) / 255.0f;
            ModelNpcAlt.editAnimDataSelect.green = (float)(CustomNpcs.colorAnimHoverPart >> 8 & 0xFF) / 255.0f;
            ModelNpcAlt.editAnimDataSelect.blue = (float)(CustomNpcs.colorAnimHoverPart & 0xFF) / 255.0f;
            this.partNames.setColorLine(CustomNpcs.colorAnimHoverPart);
            this.func_73866_w_();
        }
        if (subgui instanceof SubGuiEditAddPart) {
            SubGuiEditAddPart gui = (SubGuiEditAddPart)subgui;
            if (gui.isNew) {
                Iterator<Object> iterator = gui.animation.addParts.keySet().iterator();
                block2: while (iterator.hasNext()) {
                    int parentID = iterator.next();
                    for (AddedPartConfig apc : gui.animation.addParts.get(parentID)) {
                        if (apc.id != -1) continue;
                        gui.animation.addParts.get(parentID).remove(apc);
                        if (!gui.animation.addParts.get(parentID).isEmpty()) continue block2;
                        gui.animation.addParts.remove(parentID);
                        continue block2;
                    }
                }
                for (AnimationFrameConfig frame : gui.animation.frames.values()) {
                    frame.parts.remove(-1);
                }
                if (gui.isSave) {
                    int id = 8;
                    Iterator<Object> iterator2 = this.anim.addParts.keySet().iterator();
                    while (iterator2.hasNext()) {
                        int parentID = iterator2.next();
                        for (AddedPartConfig apc : this.anim.addParts.get(parentID)) {
                            if (id >= apc.id) continue;
                            id = apc.id + 1;
                        }
                    }
                    gui.addPart.id = id;
                    gui.part.id = id;
                    if (!this.anim.addParts.containsKey(gui.addPart.parentPart)) {
                        this.anim.addParts.put(gui.addPart.parentPart, new ArrayList());
                    }
                    this.anim.addParts.get(gui.addPart.parentPart).add(gui.addPart);
                    for (AnimationFrameConfig frame : this.anim.frames.values()) {
                        frame.parts.put(id, gui.part.copy());
                    }
                    ModelNpcAlt.loadAnimationModel(this.anim);
                    this.func_73866_w_();
                }
            }
        }
        if (subgui instanceof GuiSoundSelection && this.frame != null) {
            this.frame.setStartSound(((GuiSoundSelection)subgui).selectedResource);
            this.func_73866_w_();
        }
        if (subgui instanceof SubGuiEditText) {
            SubGuiEditText guiText = (SubGuiEditText)subgui;
            if (guiText.id == 0) {
                try {
                    int pos = Integer.parseInt(guiText.text[0]) - 1;
                    if (pos < 0) {
                        pos = 0;
                    } else if (pos > this.anim.frames.size()) {
                        pos = this.anim.frames.size();
                    }
                    this.frame = (AnimationFrameConfig)this.anim.addFrame(pos, this.frame);
                    this.setPart(this.frame.parts.get(this.part.id));
                    this.func_73866_w_();
                }
                catch (Exception e) {
                    LogWriter.error(e);
                }
            }
        }
        if (subgui instanceof SubGuiSelectItemStack) {
            SubGuiSelectItemStack guiStack = (SubGuiSelectItemStack)subgui;
            if (guiStack.id == 0) {
                this.frame.setHoldRightStack(guiStack.stack);
            } else {
                this.frame.setHoldLeftStack(guiStack.stack);
            }
            this.isChanged = true;
        }
    }

    @Override
    public void unFocused(IGuiNpcTextField textField) {
        if (this.hasSubGui() || this.anim == null) {
            return;
        }
        switch (textField.getID()) {
            case 0: {
                if (this.anim == null || this.anim.repeatLast == textField.getInteger()) {
                    return;
                }
                this.anim.setRepeatLast(textField.getInteger());
                this.isChanged = true;
                this.resetAnimation();
                break;
            }
            case 1: {
                if (this.frame == null || this.frame.speed == textField.getInteger()) {
                    return;
                }
                this.frame.setSpeed(textField.getInteger());
                this.isChanged = true;
                this.resetAnimation();
                break;
            }
            case 2: {
                if (this.frame == null || this.frame.getEndDelay() == textField.getInteger()) {
                    return;
                }
                this.frame.setEndDelay(textField.getInteger());
                this.isChanged = true;
                this.resetAnimation();
                break;
            }
            case 5: {
                this.isChanged = true;
                float sliderValue = 0.5f;
                if (this.isHitbox) {
                    if (this.hitbox == null || this.toolType == 0) {
                        return;
                    }
                    if (this.toolType == 1) {
                        this.hitbox.offset[0] = (float)textField.getDouble();
                        sliderValue = (float)textField.getDouble() * 0.1f;
                    } else {
                        this.hitbox.scale[0] = (float)textField.getDouble();
                        sliderValue = (float)textField.getDouble() * 0.2f;
                    }
                    textField.setFullText("" + (float)Math.round(textField.getDouble() * 1000.0) / 1000.0f);
                    if (this.tools.getSlider(0) != null) {
                        this.tools.getSlider(0).setSliderValue(sliderValue);
                    }
                    this.func_73866_w_();
                    return;
                }
                if (this.isMotion) {
                    if (this.frame == null || this.toolType != 1) {
                        return;
                    }
                    this.frame.motions[0] = (float)textField.getDouble();
                    sliderValue = (float)textField.getDouble() * 2.0f / 3.0f;
                    textField.setFullText("" + (float)Math.round(textField.getDouble() * 1000.0) / 1000.0f);
                    if (this.tools.getSlider(0) != null) {
                        this.tools.getSlider(0).setSliderValue(sliderValue);
                    }
                    this.func_73866_w_();
                    return;
                }
                PartConfig p = (PartConfig)this.partNames.objs[0];
                int tType = (Integer)this.partNames.objs[1];
                if (this.part == null || !this.part.equals(p) || tType != this.toolType) {
                    return;
                }
                switch (this.toolType) {
                    case 0: {
                        p.rotation[0] = (float)Math.toRadians(textField.getDouble());
                        sliderValue = (float)textField.getDouble() * 0.002778f + 0.5f;
                        break;
                    }
                    case 1: {
                        p.offset[0] = (float)textField.getDouble();
                        sliderValue = (float)textField.getDouble() * 0.1f + 0.5f;
                        break;
                    }
                    case 2: {
                        p.scale[0] = (float)textField.getDouble();
                        sliderValue = (float)textField.getDouble() * 0.2f;
                    }
                }
                textField.setFullText("" + (float)((double)Math.round(textField.getDouble() * 1000.0) / 1000.0));
                if (this.tools.getSlider(0) != null) {
                    this.tools.getSlider(0).setSliderValue(sliderValue);
                }
                this.resetAnimation();
                break;
            }
            case 6: {
                this.isChanged = true;
                float sliderValue = 0.0f;
                if (this.isHitbox) {
                    if (this.hitbox == null || this.toolType == 0) {
                        return;
                    }
                    if (this.toolType == 1) {
                        this.hitbox.offset[1] = (float)textField.getDouble();
                        sliderValue = (float)textField.getDouble() * 0.05f + 0.5f;
                    } else {
                        this.hitbox.scale[1] = (float)textField.getDouble();
                        sliderValue = (float)textField.getDouble() * 0.2f;
                    }
                    textField.setFullText("" + (float)Math.round(textField.getDouble() * 1000.0) / 1000.0f);
                    if (this.tools.getSlider(1) != null) {
                        this.tools.getSlider(1).setSliderValue(sliderValue);
                    }
                    return;
                }
                if (this.isMotion) {
                    if (this.frame == null || this.toolType != 1) {
                        return;
                    }
                    this.frame.motions[1] = (float)textField.getDouble();
                    sliderValue = (float)textField.getDouble() / 3.0f + 0.5f;
                    textField.setFullText("" + (float)Math.round((double)this.frame.motions[1] * 1000.0) / 1000.0f);
                    if (this.tools.getSlider(1) != null) {
                        this.tools.getSlider(1).setSliderValue(sliderValue);
                    }
                    this.func_73866_w_();
                    return;
                }
                PartConfig p = (PartConfig)this.partNames.objs[0];
                int tType = (Integer)this.partNames.objs[1];
                if (this.part == null || !this.part.equals(p) || tType != this.toolType) {
                    return;
                }
                switch (this.toolType) {
                    case 0: {
                        p.rotation[1] = (float)Math.toRadians(textField.getDouble());
                        sliderValue = (float)textField.getDouble() * 0.002778f + 0.5f;
                        break;
                    }
                    case 1: {
                        p.offset[1] = (float)textField.getDouble();
                        sliderValue = (float)textField.getDouble() * 0.1f + 0.5f;
                        break;
                    }
                    case 2: {
                        p.scale[1] = (float)textField.getDouble();
                        sliderValue = (float)textField.getDouble() * 0.2f;
                    }
                }
                textField.setFullText("" + (float)((double)Math.round(textField.getDouble() * 1000.0) / 1000.0));
                if (this.tools.getSlider(1) != null) {
                    this.tools.getSlider(1).setSliderValue(sliderValue);
                }
                this.resetAnimation();
                break;
            }
            case 7: {
                this.isChanged = true;
                if (this.isHitbox) {
                    float sliderValue;
                    if (this.hitbox == null || this.toolType == 0) {
                        return;
                    }
                    if (this.toolType == 1) {
                        this.hitbox.offset[2] = (float)Math.toRadians(textField.getDouble());
                        sliderValue = (float)textField.getDouble() * 0.002778f + 0.5f;
                    } else {
                        this.hitbox.scale[2] = (float)textField.getDouble();
                        sliderValue = (float)textField.getDouble() * 0.2f;
                    }
                    textField.setFullText("" + (float)Math.round(textField.getDouble() * 1000.0) / 1000.0f);
                    if (this.tools.getSlider(2) != null) {
                        this.tools.getSlider(2).setSliderValue(sliderValue);
                    }
                    return;
                }
                if (this.isMotion) {
                    if (this.frame == null || this.toolType != 1) {
                        return;
                    }
                    this.frame.motions[2] = (float)Math.toRadians(textField.getDouble());
                    float sliderValue = (float)textField.getDouble() * 0.002778f + 0.5f;
                    textField.setFullText("" + (float)Math.round(textField.getDouble() * 1000.0) / 1000.0f);
                    if (this.tools.getSlider(2) != null) {
                        this.tools.getSlider(2).setSliderValue(sliderValue);
                    }
                    this.func_73866_w_();
                    return;
                }
                PartConfig p = (PartConfig)this.partNames.objs[0];
                int tType = (Integer)this.partNames.objs[1];
                if (this.part == null || !this.part.equals(p) || tType != this.toolType) {
                    return;
                }
                float value = 0.0f;
                switch (this.toolType) {
                    case 0: {
                        p.rotation[2] = (float)Math.toRadians(textField.getDouble());
                        value = (float)textField.getDouble() * 0.002778f + 0.5f;
                        break;
                    }
                    case 1: {
                        p.offset[2] = (float)textField.getDouble();
                        value = (float)textField.getDouble() * 0.1f + 0.5f;
                        break;
                    }
                    case 2: {
                        p.scale[2] = (float)textField.getDouble();
                        value = (float)textField.getDouble() * 0.2f;
                    }
                }
                textField.setFullText("" + (float)((double)Math.round(textField.getDouble() * 1000.0) / 1000.0));
                if (this.tools.getSlider(2) != null) {
                    this.tools.getSlider(2).setSliderValue(value);
                }
                this.resetAnimation();
                break;
            }
            case 8: {
                if (this.isHitbox || this.isMotion) {
                    this.func_73866_w_();
                    return;
                }
                this.isChanged = true;
                PartConfig p = (PartConfig)this.partNames.objs[0];
                int tType = (Integer)this.partNames.objs[1];
                if (this.part == null || !this.part.equals(p) || tType != this.toolType) {
                    return;
                }
                p.rotation[3] = (float)Math.toRadians(textField.getDouble());
                float value = (float)textField.getDouble() * 0.002778f + 0.5f;
                textField.setFullText("" + (float)((double)Math.round(textField.getDouble() * 1000.0) / 1000.0));
                if (this.tools.getSlider(3) != null) {
                    this.tools.getSlider(3).setSliderValue(value);
                }
                this.resetAnimation();
                break;
            }
            case 9: {
                if (this.isHitbox || this.isMotion) {
                    this.func_73866_w_();
                    return;
                }
                this.isChanged = true;
                PartConfig p = (PartConfig)this.partNames.objs[0];
                int tType = (Integer)this.partNames.objs[1];
                if (this.part == null || !this.part.equals(p) || tType != this.toolType) {
                    return;
                }
                p.rotation[4] = (float)Math.toRadians(textField.getDouble());
                float value = (float)textField.getDouble() * 0.005556f + 0.5f;
                textField.setFullText("" + (float)((double)Math.round(textField.getDouble() * 1000.0) / 1000.0));
                if (this.tools.getSlider(4) != null) {
                    this.tools.getSlider(4).setSliderValue(value);
                }
                this.resetAnimation();
                break;
            }
            case 10: {
                if (this.anim == null) {
                    return;
                }
                this.anim.chance = (float)Math.round(textField.getDouble() * 1000.0) / 100000.0f;
                textField.setFullText("" + this.anim.chance * 100.0f);
                this.isChanged = true;
                this.resetAnimation();
                break;
            }
            case 11: {
                if (this.anim == null) {
                    return;
                }
                this.anim.name = textField.getFullText();
            }
        }
    }

    @Override
    public void save() {
        if (this.anim != null) {
            Client.sendData(EnumPacketServer.AnimationChange, this.anim.save());
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74757_a("save", true);
        Client.sendData(EnumPacketServer.EmotionChange, nbt);
    }

    @Override
    public void closeMiniWindow(IGuiNpcMiniWindow miniWindow) {
        this.miniWindows.remove(miniWindow.getID());
        if (miniWindow.getID() == 0 && this.getButton(29) != null) {
            this.getButton(29).setEnabled(!this.miniWindows.containsKey(0));
        }
        if (miniWindow.getID() == 1 && this.getButton(35) != null) {
            this.getButton(35).setEnabled(!this.miniWindows.containsKey(1));
        } else if (miniWindow.getID() == 2 && this.getButton(45) != null) {
            this.getButton(45).setEnabled(!this.miniWindows.containsKey(2));
        }
    }
}

